function y=DownSample3_Smooth(x)
%
% y=DownSample3_Smooth(x)
%
% Smoothly downsamples a given input 3-d data 'x' by
% taking the 2nd band of a two-level Laplacian pyramid
% for each of the slices (frames)
%
% returns the smoothed, downsampled data in 'y'
%

curr_dir = pwd;
cd ../PyramidTools/

for k=1:size(x,3)
	yy = squeeze(x(:,:,k));

	[pyr ind] = buildLpyr(yy,2);		% 2-level Lap. pyramid

	yb = pyrBand(pyr,ind,2);		% 2nd band (LowPass)

str = sprintf('k=%d --> original range [%d %d], new range [%d %d]',...
k,round(min(min(yy))), round(max(max(yy))), round(min(min(yb))), ...
round(max(max(yb))));
disp(str);

	y(:,:,k) = yb;
end

cd(curr_dir);

