function [y,n]=addGaussNoise_OLD(x,dSNR)
%
% [y n]=addGaussNoise_OLD(x,dSNR)
%
% adds zero-mean Gaussian noise to a signal 'x' so that the desired SNR
% is 'dSNR' and returns the result in 'y'
%

n  = randn(size(x));        % Generate N(0,1) noise

Px = sum(x(:).^2);          % Signal power
Pn = sum(n(:).^2);          % Noise power

K  = Px / Pn;               % Signal/Noise power ratio

n  = n * sqrt(K/dSNR);      % Modify the noise

y  = x + n;                 % Noisy signal

%
% Copyright (c) 2002, Nasir M. Rajpoot
%