function xI=computeInvLocalFFT3(xF,winSize)
%
% xI = computeInvLocalFFT3(xF,winSize)
%
% Takes the local 3-dimensional FFT of given volume 'xF'
% using the cube size 'winSize' in the format [wx wy wz]
% and returns the result in xI
%
% WARNING: No window overlap is used at the moment.
%
% First written by Nasir Rajpoot; 12/2002
%

verbose = false;

sizex = size(xF);
sx    = floor(sizex./winSize) .* winSize;

if ( (sx(1) ~= sizex(1)) | (sx(2) ~= sizex(2)) | (sx(3) ~= sizex(3)) )
	error('The window size does not divide volume size ..');
	return;
end

numCubes = sizex./winSize;

for pp=1:numCubes(3)
for nn=1:numCubes(2)
for mm=1:numCubes(1)
	if (verbose)
		disp(sprintf('Now computing local FFT for cube index (%d,%d,%d) ..', mm,nn,pp));
	end

	[xi xf yi yf zi zf]   = getCubeIndices(mm, nn, pp, winSize);

	xI(xi:xf,yi:yf,zi:zf) = ifftn(ifftshift(xF(xi:xf,yi:yf,zi:zf)));
end
end
end

