function xF=computeLocalFFT3(x,winSize,absFlag)
%
% xF = computeLocalFFT3(x,winSize,absFlag)
%
% Takes the local 3-dimensional FFT of given volume 'x'
% using the cube size 'winSize' given in [wx wy wz] format
% and returns the result in xF
%
% The 'absFlag' causes the program to return FFT as follows:
%
%   0 --> FFT in complex form [with fftshift]
%   1 --> log(1+abs(.))       [with fftshift]
%
%   2 --> FFT in complex form [without fftshift]
%
% WARNING: No window overlap is used at the moment.
%
% First written by Nasir Rajpoot; 12/2002
%

verbose = false;

sizex = size(x);
sx    = floor(sizex./winSize) .* winSize;

if ( (sx(1) ~= sizex(1)) | (sx(2) ~= sizex(2)) | (sx(3) ~= sizex(3)) )
	error('The window size does not divide volume size ..');
	return;
end

numCubes = sizex./winSize;

for pp=1:numCubes(3)
for nn=1:numCubes(2)
for mm=1:numCubes(1)
	if (verbose)
		disp(sprintf('Now computing local FFT for cube index (%d,%d,%d) ..', mm,nn,pp));
	end

	[xi xf yi yf zi zf] = getCubeIndices(mm, nn, pp, winSize);

	switch (absFlag)
	case 0
		xF(xi:xf,yi:yf,zi:zf) = fftshift(fftn(x(xi:xf,yi:yf,zi:zf)));
	case 1
		xF(xi:xf,yi:yf,zi:zf) = log(1+abs(fftshift(fftn(x(xi:xf,yi:yf,zi:zf)))));
	case 2
		xF(xi:xf,yi:yf,zi:zf) = fftn(x(xi:xf,yi:yf,zi:zf));
	end
end
end
end

