% xPyr = computeLpyr3(x, height, filt1, filt2, edges)
%
% Construct a Laplacian pyramid on 3-d volume 'x' upto 'height'
% number of levels using 'filt1' for correlation and 'filt2'
% for convolution (for highpass filtering), returning the result
% in a cell array 'xPyr'
%
% [edges option is default to 'reflect' and is not taken
%  any futher yet].
%
% Written by Nasir Rajpoot, 11/02.

function xPyr = computeLpyr3(x, height, filt1, filt2, edges)

if (nargin < 2)
  disp('At least first two arguments should be provided ..');
  return
end

size_x = size(x);

%------------------------------------------------------------
%% OPTIONAL ARGS:
%------------------------------------------------------------

if (exist('filt1') ~= 1)
  filt1 = 'binom5';
end
 
if isstr(filt1)
  filt1 = namedFilter(filt1);
end

if ( (size(filt1,1) > 1) & (size(filt1,2) > 1) )
  error('FILT1 should be a 1D filter (i.e., a vector)');
else
  filt1 = filt1(:);
end

if (exist('filt2') ~= 1)
  filt2 = filt1;
end

if isstr(filt2)
  filt2 = namedFilter(filt2);
end

if ( (size(filt2,1) > 1) & (size(filt2,2) > 1) )
  error('FILT2 should be a 1D filter (i.e., a vector)');
else
  filt2 = filt2(:);
end

max_ht = 1 + maxPyrHt3(size_x, max(size(filt1,1), size(filt2,1)));
if ( (exist('height') ~= 1) | (height == 'auto') )
  height = max_ht;
else
  if (height > max_ht)
    error(sprintf('Cannot build pyramid higher than %d levels.',max_ht));
  end
end

if (exist('edges') ~= 1)
  edges= 'reflect1';
end

%------------------------------------------------------------

[pyr ind] = buildLpyr3(x,height,filt1,filt2,edges);

start_ind = 1;

for k=1:size(ind,1)	% number of subbands

	band_size = ind(k,:);
	stop_ind  = start_ind + prod(band_size) - 1;

	xPyr{k}   = reshape(pyr(start_ind:stop_ind), band_size);

	start_ind = stop_ind + 1;

end

