function [y00,y01,y10,y11]=cosWin2d(x,bsize)
%
% [y00 y01 y10 y11] = cosWin2d(x,bsize)
%
% returns the four Hanning-windowed images 'y00,y01,y10,y11'
% of the image 'x' using the block size 'bsize'
%
% where
%
% size(x)   = [m       n]
%
% size(y00) = [m       n]
% size(y01) = [m+bsize n]
% size(y10) = [m       n+bsize]
% size(y11) = [m+bsize n+bsize]
%

%h = waitbar(0,'Row windowing ...');
for m=1:size(x,1)
	[x0 x1] = cosWin(x(m,:),bsize(1));

	y0(m,:) = x0;
	y1(m,:) = x1;

%	waitbar(m/size(x,1),h)
end
%close(h)

%h = waitbar(0,'Column windowing for the first windowed signal ...');
for n=1:size(y0,2)
	[x0 x1]  = cosWin(y0(:,n),bsize(2));
	y00(:,n) = x0';
	y01(:,n) = x1';

%	waitbar(n/size(x,2),h)
end
%close(h)

%h = waitbar(0,'Column windowing for the second windowed signal ...');
for n=1:size(y1,2)
	[x0 x1]  = cosWin(y1(:,n),bsize(2));
	y10(:,n) = x0';
	y11(:,n) = x1';

%	waitbar(n/size(x,2),h)
end
%close(h)



