function [y000,y001,y010,y011,y100,y101,y110,y111]=cosWin3d(x,bsize)
%function [y0,y1]=cosWin3d(x,bsize)
%
% [y000,y001,y010,y011,y100,y101,y110,y111]=cosWin3d(x,bsize)
%
% returns the eight Hanning-windowed images 'y000,y001,...,y111'
% of the image 'x' using the block size 'bsize'
%
% where
%
% size(x)    = [m        n        k]
%
% size(y000) = [m        n        k]
% size(y001) = [m+bsize1 n        k]
% size(y010) = [m        n+bsize2 k]
% size(y011) = [m+bsize1 n+bsize2 k]
%
% size(y100) = [m        n        k+bsize3]
% size(y101) = [m+bsize1 n        k+bsize3]
% size(y110) = [m        n+bsize2 k+bsize3]
% size(y111) = [m+bsize1 n+bsize2 k+bsize3]
%

disp('  Windowing in the depth direction ...');

[w0 w1] = makeCosWin(size(x,3),bsize(3));

disp('    Starting the first half ..');
for k=1:size(x,3)
	%win0      = repmat(w0(k), [size(x,1) size(x,2)]);
	%y0(:,:,k) = win0 .* x(:,:,k);
	win0(:,:,k) = repmat(w0(k), [size(x,1) size(x,2)]);
end
y0 = win0 .* x;

disp('      Done with the first half ..');
clear win0

disp('    Starting the second half ..');
for k=1:size(x,3)+bsize(3)
	win1(:,:,k) = repmat(w1(k), [size(x,1) size(x,2)]);
end

y1 = zeros(size(x,1), size(x,2), bsize(3)/2);
y1(:,:,bsize(3)/2+1:size(x,3)+bsize(3)/2) = x;
y1(:,:,size(x,3)+bsize(3)/2+1:size(x,3)+bsize(3)) = zeros(size(x,1), size(x,2), bsize(3)/2);

y1 = win1 .* y1;

disp('      Done with the second half ..');
clear win1

disp ('  Windowing in x,y directions ..');
disp ('    Starting the first half ..');
h = waitbar(0,'Please wait ..');
for k=1:size(x,3)
	[y000(:,:,k) y001(:,:,k) y010(:,:,k) y011(:,:,k)] = ...
		cosWin2d (y0(:,:,k), [bsize(1) bsize(2)]);

	waitbar(k/size(x,3),h);
end
close(h);

disp ('      Done with the first half ..');
disp ('    Starting the second half ..');
h = waitbar(0,'Please wait ..');
for k=1:(size(x,3)+bsize(3))
	[y100(:,:,k) y101(:,:,k) y110(:,:,k) y111(:,:,k)] = ...
		cosWin2d (y1(:,:,k), [bsize(1) bsize(2)]);

	waitbar(k/(size(x,3)+bsize(3)),h);
end
close(h);
disp ('      Done with the second half ..');




%--------------------------------

function [w0,w1]=makeCosWin(n,b)

nBlocks = round (n / b);
if (nBlocks ~= n/b)
	error(sprintf('Length %d not divisible by block size %d ..',n,b));
end

nPeriod0 = nBlocks/2;
nPeriod1 = nPeriod0 + 1/2;

%tstep0   = (nPeriod0*2*pi)/(n-1);
tstep1   = (nPeriod1*2*pi)/(n+b-1);

t1 = 0:tstep1:nPeriod1*(2*pi);

w0 = sin(t1).^2;
w1 = cos(t1).^2;
w0 = w0( (b/2+1) : (n+b/2));


%--------------------------------



