function [x,xn,xd]=denoise3_LPyrThreshWin(dsnr,theta,nframes,x)
%
% [x,xn,xd] = denoise3_LPyrThresh(dsnr,theta,nframes,x)
%
% Denoising 3D image data using thresholding of the 3D Lapalcian
% Pyramid local FFT
%
% dsnr         --> Desired SNR of noisy image
% theta        --> threshold value ('soft' for adaptive)
% nframes      --> range of frames to display for comparison
% x (optional) --> image data (default: MissA sequence)
%

%*******************
if (nargin < 3)
	help denoise3_LPyrThresh
	error('Bad input arguments ..');
end

%*******************
nlev    = 3;
wSize   = [16 16 16];
%theta = sqrt(2*log(n)) * std(noise);

ptime   = 0.1;

%*******************

if (exist('x'))
	disp('Using the input 3-D data variable ''x'' ..');
else
	disp('Loading the 3D Miss America sequence ..');

	load missa_complete
	%x = y(10:265,80:335,23:150);
	x = y(80:207,155:282,23:150);
	x = double(x);
	clear y
end

%*******************
disp('Adding Gaussian white noise ..');

[xn,sigma] = addGaussNoise(x,dsnr);

%*******************
s0 = computeSNR(x,xn);
disp(sprintf('SNR of the noisy image data is: %-6.2fdB ..',s0));

%*******************
disp(sprintf('Computing %d-level 3D Laplacian pyramid ..',nlev));

%pyr = computeLpyr3(xn,3);
pyr = computeLpyr3(x,3);

%*******************
for k=1:nlev
disp(sprintf('Band number: %d',k));
	bandK      = pyr{k};

	[b0 b1 b2 b3 b4 b5 b6 b7] = cosWin3d(bandK,wSize);
	clear bankK

str=sprintf('  Computing local FFT with [%d %d %d] window ..', ...
wSize(1),wSize(2),wSize(3));
disp(str);
	% bandK_LFFT = computeLocalFFT3(bandK,wSize,0);
	b0 = computeLocalFFT3(b0,wSize,0);
	b1 = computeLocalFFT3(b1,wSize,0);
	b2 = computeLocalFFT3(b2,wSize,0);
	b3 = computeLocalFFT3(b3,wSize,0);
	b4 = computeLocalFFT3(b4,wSize,0);
	b5 = computeLocalFFT3(b5,wSize,0);
	b6 = computeLocalFFT3(b6,wSize,0);
	b7 = computeLocalFFT3(b7,wSize,0);
disp('  Thresholding the local FFT ..');
	if (theta == 'soft')
		%bandK_LFFT = softThresh3(bandK_LFFT,sigma);
		b0 = softThresh3(b0,sigma);
		b1 = softThresh3(b1,sigma);
		b2 = softThresh3(b2,sigma);
		b3 = softThresh3(b3,sigma);
		b4 = softThresh3(b4,sigma);
		b5 = softThresh3(b5,sigma);
		b6 = softThresh3(b6,sigma);
		b7 = softThresh3(b7,sigma);
	else
		%bandK_LFFT = hardThresh3(bandK_LFFT,theta);
		b0 = hardThresh3(b0,theta);
		b1 = hardThresh3(b1,theta);
		b2 = hardThresh3(b2,theta);
		b3 = hardThresh3(b3,theta);
		b4 = hardThresh3(b4,theta);
		b5 = hardThresh3(b5,theta);
		b6 = hardThresh3(b6,theta);
		b7 = hardThresh3(b7,theta);
	end
str=sprintf('  Computing inv. local FFT with [%d %d %d] window ..',...
wSize(1),wSize(2),wSize(3));
disp(str);
	%bandK      = computeInvLocalFFT3(bandK_LFFT,wSize);
	%pyr{k}     = real(bankK);
	b0     = computeInvLocalFFT3(b0,wSize);
	b1     = computeInvLocalFFT3(b1,wSize);
	b2     = computeInvLocalFFT3(b2,wSize);
	b3     = computeInvLocalFFT3(b3,wSize);
	b4     = computeInvLocalFFT3(b4,wSize);
	b5     = computeInvLocalFFT3(b5,wSize);
	b6     = computeInvLocalFFT3(b6,wSize);
	b7     = computeInvLocalFFT3(b7,wSize);

	b0  = iCosWin3d(b0,b1,b2,b3,b4,b5,b6,b7, wSize);

	pyr{k} = real(b0);

	clear b0 b1 b2 b3 b4 b5 b6 b7
end

%*******************
disp(sprintf('Computing %d-level inverse 3D Laplacian pyramid ..',nlev));

xd = reconLpyr3(pyr);

%*******************
s1 = computeSNR(x,xd);
disp(sprintf('SNR of the denoised image data is: %-6.2fdB ..',s1));

%*******************
disp('Displaying one of the frames ..');

for k=nframes
	subplot(1,3,1);
	showImage3(x,k,1,0);
	title(sprintf('Original frame# %d',k));

	subplot(1,3,2);
	showImage3(xn,k,1,0);
	title(sprintf('Noisy frame# %d',k));

	subplot(1,3,3);
	showImage3(xd,k,1,0);
	title(sprintf('Denoised frame# %d',k));

	pause(ptime);
end

gtext(sprintf('SNR: Before --> %5.2fdB, After --> %5.2fdB',s0,s1));


%----------------------------------------------------------------

function yc=hardThresh3(xc,theta)

%
% yc=hardThresh3(xc,theta)
%
% Thresholds the 3D complex input 'xc' using threshold 'theta'
% (by equating to zero all inputs with magnitude below threshold)
% and returns the result in 'yc'
%
yc   = log(1+abs(xc));
mini = min(min(min(yc)));
maxi = max(max(max(yc)));

ind  = find(yc<theta);
pct  = length(ind)/length(xc(:)) * 100;

disp(sprintf('  [min=%f, max=%f, theta=%f] (%d%% coeffs below thr)',...
	min(min(min(yc))),...
	max(max(max(yc))), theta, round(pct)));

xc(ind) = 0;
yc = xc;


%----------------------------------------------------------------

function yc=softThresh3(xc,sigma)

%
% yc=softThresh3(xc,sigma)
%
% Soft thresholds the 3D complex input 'xc' using noise s.d.
% (by equating to zero all inputs with magnitude below threshold)
% and returns the result in 'yc'
%
% theta = sqrt(2*log(n)) * sigma
%
yc    = log(1+abs(xc));
mini  = min(min(min(yc)));
maxi  = max(max(max(yc)));

%sigma
theta = sqrt(2*log(prod(size(xc))));
%theta = theta * ( 0.46*log10(sigma) + 0.92 );
theta = theta * ( 0.4*log10(sigma) + 0.8 );
%theta = theta * 1.25
%theta = 0.75*maxi;

ind   = find(yc<theta);
pct   = length(ind)/length(xc(:)) * 100;

disp(sprintf('  [min=%f, max=%f, theta=%f] (%d%% coeffs below thr)',...
	min(min(min(yc))),...
	max(max(max(yc))), theta, round(pct)));

xc(ind) = 0;
yc = xc;




