function xd =denoise3_Packet(sigma,theta,xn)
%
% [x,xn,xd] = denoise3_LPyrThresh(dsnr,theta,nframes,x)
%
% Denoising 3D image data using thresholding of the 3D Lapalcian
% Pyramid local FFT
%
% dsnr         --> Desired SNR of noisy image
% theta        --> threshold value ('soft' for adaptive)
% nframes      --> range of frames to display for comparison
% x (optional) --> image data (default: MissA sequence)
%

%*******************
if (nargin < 3)
	help denoise3_LPyrThresh
	error('Bad input arguments ..');
end

%*******************
nlev    = 3;
wSize   = [16 16 16];
%theta = sqrt(2*log(n)) * std(noise);

ptime   = 0.1;

%*******************

% if (exist('x'))
% 	disp('Using the input 3-D data variable ''x'' ..');
% else
% 	disp('Loading the 3D Miss America sequence ..');
% 
% 	load missa_complete
% 	%x = y(10:265,80:335,23:150);
% 	x = y(80:207,155:282,23:150);
% 	x = double(x);
% 	clear y
% end

%*******************
%[xn,sigma] = addGaussNoise(x,dsnr);

%*******************

%*******************
pyr = computeLpyr3(xn,3);
% pyr = computeLpyr3(x,3);

%*******************
for k=1:nlev-1
	bandK      = pyr{k};
    packet=computeLpyr3(bandK,nlev-k+1);
    for z=1:nlev-k;
        bandKZ=packet{z};
        
        bandKZ_LFFT = computeLocalFFT3(bandKZ,wSize,0);

        if (theta == 'soft')
            if (z == 1)
                bandKZ_LFFT = softThresh3(bandKZ_LFFT,sigma);
            else
                bandKZ_LFFT = sureShrink(bandKZ_LFFT,sigma);
            end
        else
            bandKZ_LFFT = hardThresh3(bandKZ_LFFT,theta);
        end
        bandKZ      = computeInvLocalFFT3(bandKZ_LFFT,wSize);
        packet{z}     = real(bandKZ);
    end

    pyr{k} = reconLpyr3(packet);
end

xd = reconLpyr3(pyr);

%*******************
% s1 = computeSNR(x,xd);
% disp(sprintf('SNR of the denoised image data is: %-6.2fdB ..',s1));

%*******************
% disp('Displaying one of the frames ..');
% 
% for k=nframes
% 	subplot(1,3,1);
% 	showImage3(x,k,1,0);
% 	title(sprintf('Original frame# %d',k));
% 
% 	subplot(1,3,2);
% 	showImage3(xn,k,1,0);
% 	title(sprintf('Noisy frame# %d',k));
% 
% 	subplot(1,3,3);
% 	showImage3(xd,k,1,0);
% 	title(sprintf('Denoised frame# %d',k));
% 
% 	pause(ptime);
% end
% 
% gtext(sprintf('SNR: Before --> %5.2fdB, After --> %5.2fdB',s0,s1));


%----------------------------------------------------------------

function yc=hardThresh3(xc,theta)

%
% yc=hardThresh3(xc,theta)
%
% Thresholds the 3D complex input 'xc' using threshold 'theta'
% (by equating to zero all inputs with magnitude below threshold)
% and returns the result in 'yc'
%
yc   = log(1+abs(xc));
mini = min(min(min(yc)));
maxi = max(max(max(yc)));

ind  = find(yc<theta);
pct  = length(ind)/length(xc(:)) * 100;

disp(sprintf('  [min=%f, max=%f, theta=%f] (%d%% coeffs below thr)',...
	min(min(min(yc))),...
	max(max(max(yc))), theta, round(pct)));

xc(ind) = 0;
yc = xc;


%----------------------------------------------------------------

function yc=softThresh3(xc,sigma)

%
% yc=softThresh3(xc,sigma)
%
% Soft thresholds the 3D complex input 'xc' using noise s.d.
% (by equating to zero all inputs with magnitude below threshold)
% and returns the result in 'yc'
%
% theta = sqrt(2*log(n)) * sigma
%
yc    = log(1+abs(xc));
mini  = min(min(min(yc)));
maxi  = max(max(max(yc)));
a=0.46;
%sigma
theta = sqrt(2*log(prod(size(xc))));
theta = theta * ( a*log10(sigma) + 2*a );
%theta = theta * 1.25
%theta = 0.75*maxi;

ind   = find(yc<theta);
pct   = length(ind)/length(xc(:)) * 100;

disp(sprintf('  [min=%f, max=%f, theta=%f] (%d%% coeffs below thr)',...
	min(min(min(yc))),...
	max(max(max(yc))), theta, round(pct)));

xc(ind) = 0;
yc = xc;

%------------------------------------
function yc=sureShrink(xc, sigma)
[x1, y1, z1]=size(xc);
m=x1*y1*z1;
oct=reshape(xc, 1, m);
std_oct = std(oct);
if (std_oct ~= 0)
    yc = reshape(SUREThresh(oct/std_oct, sigma),x1,y1,z1) * std_oct;
end



