function xd =denoise3_LPyrThresh(sigma,theta,xn)
%
% [x,xn,xd] = denoise3_LPyrThresh(dsnr,theta,nframes,x)
%
% Denoising 3D image data using thresholding of the 3D Lapalcian
% Pyramid local FFT
%
% dsnr         --> Desired SNR of noisy image
% theta        --> threshold value ('soft' for adaptive)
% nframes      --> range of frames to display for comparison
% x (optional) --> image data (default: MissA sequence)
%

%*******************
if (nargin < 3)
	help denoise3_LPyrThresh
	error('Bad input arguments ..');
end

%*******************
nlev    = 3;
wSize   = [16 16 16];
%theta = sqrt(2*log(n)) * std(noise);

ptime   = 0.1;

%*******************
pyr = computeLpyr3(xn,nlev);
% pyr = computeLpyr3(x,3);

%*******************
for k=1:nlev-1,

	bandK      = pyr{k};
bandK_LFFT = computeLocalFFT3(bandK,wSize,0);
       
    m=prod(size(bandK_LFFT));
    oct_abs=sort(reshape(abs(bandK_LFFT), 1, m));
            
            if (k == 1) % we are in hhh band
                %estimate the noise variance
                median=oct_abs(int16(m / 2));            
                noise_var = (median / 0.6745);
                %noise_var =m=prod(size(oct));
            end
            
	if (theta == 'soft')
		%bandK_LFFT = softThresh3(bandK_LFFT,sigma);
        %bandK_LFFT = sureShrink(bandK_LFFT,sigma);
        if (k==1) 
             bandK_LFFT = softThresh3(bandK_LFFT,sigma);
         else
             bandK_LFFT = sureShrink(bandK_LFFT,sigma);
         end
	else
		bandK_LFFT = hardThresh3(bandK_LFFT,theta);
	end

	bandK      = computeInvLocalFFT3(bandK_LFFT,wSize);

	pyr{k}     = real(bandK);
end

%*******************
xd = reconLpyr3(pyr);

%*******************


%*******************

%----------------------------------------------------------------

function yc=hardThresh3(xc,theta)

%
% yc=hardThresh3(xc,theta)
%
% Thresholds the 3D complex input 'xc' using threshold 'theta'
% (by equating to zero all inputs with magnitude below threshold)
% and returns the result in 'yc'
%
yc   = log(1+abs(xc));
mini = min(min(min(yc)));
maxi = max(max(max(yc)));

ind  = find(yc<theta);
pct  = length(ind)/length(xc(:)) * 100;


xc(ind) = 0;
yc = xc;


%----------------------------------------------------------------

function yc=softThresh3(xc,sigma)

%
% yc=softThresh3(xc,sigma)
%
% Soft thresholds the 3D complex input 'xc' using noise s.d.
% (by equating to zero all inputs with magnitude below threshold)
% and returns the result in 'yc'
%
% theta = sqrt(2*log(n)) * sigma
%
yc    = log(1+abs(xc));
mini  = min(min(min(yc)));
maxi  = max(max(max(yc)));
a=0.46;
%sigma
theta = sqrt(2*log(prod(size(xc))));
theta = theta * ( a*log10(sigma) + a*2 );
%theta = theta * 1.25
%theta = 0.75*maxi;

ind   = find(yc<theta);
pct   = length(ind)/length(xc(:)) * 100;


xc(ind) = 0;
yc = xc;

%------------------------------------
function yc=sureShrink(xc, sigma)
[x1, y1, z1]=size(xc);
m=x1*y1*z1;
oct=reshape(xc, 1, m);
std_oct = std(oct);
if (std_oct ~= 0)
    yc = reshape(SUREThresh(oct/std_oct, sigma),x1,y1,z1) * std_oct;
end

