function x=genCircleVideo(imsize)
%
% x=genCircleVideo(imsize)
%
% Generates a video sequence (each frame size 'imsize') with a
% moving circle, returned in the output variable 'x'
%
% WARNING: Hard-wired values for circle radius and moving centre
%          are used, at the moment.
%

cradius  = 10;
ccentre  = [64 64];
DOTVALUE = 1;
%mstyle   = 'DiagonalCircle';
mstyle   = 'SineWaveCircle';
nFrames  = 128;

switch mstyle
case 'DiagonalCircle'
	for k=1:nFrames
		ccentre = ccentre+[1 1];

		x(:,:,k) = genCircle(ccentre,cradius,[imsize(1:2)],DOTVALUE);
	end
case 'SineWaveCircle'
	A = 40;				% amplitude
	f = 1;				% freq (Hz)
	s = sineWave(A,f,nFrames);

	ocentre = [128 64];

	for k=1:nFrames
		ccentre = round(ocentre - [s(k) -k]);

		x(:,:,k) = genCircle(ccentre,cradius,[imsize(1:2)],DOTVALUE);
	end
end


%
function xc=genCircle(c,r,csize,fillValue)
%
theta  = 0:pi/1000:2*pi;

ctheta = cos(theta);
stheta = sin(theta);
xcoord = c(1) + round(r*ctheta);
ycoord = c(2) + round(r*stheta);

xc = zeros(csize(1),csize(2));

for k=1:length(theta)
	xck = xcoord(k);
	yck = ycoord(k);

	if ( (xck >= 1 && xck <= csize(1)) && (yck >= 1 && yck <= csize(2)) )
		xc(xck,yck) = fillValue;
	end
end

