function c=inertiaTensorBlock(xF,winSize,fname)
%
% c = inertiaTensorBlock(xF,winSize)
%
% Computes the local inertia tensor of the whole windowed FT 'xF'
% (computed presumably with 3D window size 'winSize')
%
% WARNING: No window overlap is used at the moment.
%
% First written by Nasir Rajpoot; 12/2002
%

xF_energy = sum(sum(sum(abs(xF).^2)));

verbose  = true;
sizex    = size(xF);
numCubes = sizex./winSize;

h = waitbar(0,'Please wait ..');

fid = fopen(fname,'wb');

for pp=1:numCubes(3)
for nn=1:numCubes(2)
for mm=1:numCubes(1)
%	if (verbose)
%		disp(sprintf('cube index (%d,%d,%d): ', mm,nn,pp));
%	end

	[xi xf yi yf zi zf] = getCubeIndices(mm, nn, pp, winSize);

	bf = xF(xi:xf,yi:yf,zi:zf);
	c  = inertiaTensorRotated(bf,winSize);

	% c/(sqrt(prod(winSize)))
	c = c/(prod(winSize(1:2)));

	A = sum(sum(sum(abs(bf).^2))) / xF_energy;

	if (sum(sum(abs(c))) ~= 0)
		writePars_Block(A,xi,yi,zi,c,fid);
	end
end
%
nIter = ((pp-1)*numCubes(2)) + nn;
nTotal= numCubes(3)*numCubes(2);
rIter = nIter / nTotal;
waitbar(rIter,h,sprintf('%d out of %d iterations (%d%%) ..',nIter,nTotal,round(rIter*100.0)));
%
end
end

close(h);
fclose(fid);

%
function writePars_Block(A,xi,yi,zi,c,fid)
%
bDim    = 16;			% Fixed dimension (each direction)

[cV cD] = eig(c);
cD      = [cD(1,1) cD(2,2) cD(3,3)];
[mE iE] = max(cD);


fprintf(fid,'%d %d %d %d\n', yi-1, xi-1, zi-1, bDim);
fprintf(fid,'%f\n',A*1000);
fprintf(fid,'%d %d %d\n',bDim/2,bDim/2,bDim/2);% centre position
fprintf(fid,'MATRIX 3 x 3\n');
fprintf(fid,'%f,%f,%f\n', c(1,1),c(1,2),c(1,3));
fprintf(fid,'%f,%f,%f\n', c(2,1),c(2,2),c(2,3));
fprintf(fid,'%f,%f,%f\n', c(3,1),c(3,2),c(3,3));
fprintf(fid,'\n');
fprintf(fid,'%f ',cV(:,iE));		% PC axis
fprintf(fid,'\n');
fprintf(fid,'%f ',sqrt(cD)/bDim);	% scaled eigenvalues (for s.d.)
fprintf(fid,'\n');
fprintf(fid,'0.0\n');			% MSE
fprintf(fid,'1.0 1.0\n');		% A*sumXG sumXX

