function c=intertiaTensorRotated(f,bsize)
%
% c=inertiaTensorRotated(f)
%
% Second order moment (covariance matrix) of the 3-D local FFT
% (complex) of a volume block 'f' of the size 'bSize'; the result
% is returned in a 3x3 matrix 'c'
%
% The given volume block is first rotated and translated so that
% the origin is at the bottom and x-y axes are like normal
% mathematical convention
% (x going from left to right horizontally and
%  y going from top to bottom vertically)
%

for k=1:size(f,3)
	f(:,:,k) = imrotate(squeeze(f(:,:,k)),90,'crop');
end

c = zeros(3,3);

for m=1:size(f,1)
	for n=1:size(f,2)
		for p=1:size(f,3)

			scoords = scaledCoords([m n p],bsize);	% scaled coords
			w       = scoords' * scoords;		% weight matrix
			energy  = abs(f(m,n,p)) .^ 2;		% energy at point

			c = c + (energy * w);
		end
	end
end

c = c / prod(bsize);

