% showImage3_two(x, frame_range, info_flag, pause_time)
%
% Display a range of frames from a 3-d sequence/volume
% 'x' with 'pause_time' (default 0.1) secs between any
% two frames
%
% Set 'info_flag' to 1, if you would like to see the
% min,max,ave information about each frame
%
% Written by Nasir Rajpoot, 11/02.

function showImage3_two(x, y, frame_range, info_flag, pause_time)

if (nargin < 2)
  disp('At least first two arguments should be provided ..');
  return
end

%------------------------------------------------------------
%% OPTIONAL ARGS:
%------------------------------------------------------------

if (nargin < 3)
  frame_range = 1:size(x,3);
  info_flag   = 0;
  pause_time  = 0.1;
end

if (nargin < 4)
  info_flag   = 0;
  pause_time  = 0.1;
end

if (nargin < 5)
  pause_time  = 0.1;
end

%------------------------------------------------------------

for k=frame_range
	xframe = squeeze(x(:,:,k));
	yframe = squeeze(y(:,:,k));
	if (info_flag)
		disp(sprintf('x frame# --> %3d: min=%f, max=%f, ave=%f', k, min(min(xframe)), max(max(xframe)), mean(mean(xframe))));
		disp(sprintf('y frame# --> %3d: min=%f, max=%f, ave=%f', k, min(min(yframe)), max(max(yframe)), mean(mean(yframe))));
	end

	subplot(121);
	imagesc(xframe);
	colormap(gray(256));
	axis('image');
	title(sprintf('x frame# %d', k));

	subplot(122);
	imagesc(yframe);
	colormap(gray(256));
	axis('image');
	title(sprintf('y frame# %d', k));

	drawnow;

	pause(pause_time);
end

