function writeFrames(x,dirname,prefix)
%
% writeFrames(x,dirname,prefix)
%
% writes the 3-d data 'x' onto the directory 'dirname' below
% the current working directory by creating PPM images for
% each slice name of which is of the format 'prefix%d.ppm'
%

h = waitbar(0,'Please wait ..');

for k=1:size(x,3)

	xslice = scalePixels ( squeeze(x(:,:,k)) );
	fname  = sprintf('%s/%s%03d.tif',dirname,prefix,k);
	
	imwrite(xslice,gray(256),fname,'TIFF');

	waitbar(k/size(x,3),h);
end

close(h);



%function writePPMFile(x,filename)
%%
%%
%fid=fopen(filename,'wb');
%
%fwrite(fid,'P3');
%fwrite(fid,'# test script');
%fwrite(fid,'%d %d',);



