function writeGipl(image,filename)
%   writeGipl:  Write an image to the Gipl formatdata file in binary format
%
%   writeGipl(image,'filename')
%
%   filename - input image name (eg '/bigdaily/foo.gipl')
%
%   The function write an image to Gipl image format
%
%   Author: Carl-Fredrik Westin, SPL, Harvard   Date: 970518

if nargin < 2
 help writeGipl;
 return;
end;
image.misc
if(~(image.misc.magicNumber==719555000))
 error('Sorry, not a proper header');
 return
end;

[fid,message] = fopen(filename,'w+');
if (fid==-1)
%   disp(message);
   error(message);
   return
end


% ***************************************************
% write gipl header information
% ***************************************************

%ADD TESTS!!!!!!!!!

% image size, and number of phases (volumes)
% padd ones to dimension 4, and swap hgh and wid sizes
image.imDim(1:2) = [image.imDim(2) image.imDim(1)];
image.imDim = [image.imDim ones(1,4 - length(image.imDim))];
fwrite(fid,image.imDim,'short','b');

% patent description
fwrite(fid,image.misc.imageType,'short','b');

% voxel dimensions
image.voxDim = [image.voxDim ones(1,4 - length(image.voxDim))];
fwrite(fid,image.voxDim,'float','b');

% patent description
fwrite(fid,image.misc.patientDesc,'char','b');

fwrite(fid,image.misc.matrixElements,'float','b');
fwrite(fid,image.misc.identifier,'int','b');
fwrite(fid,image.misc.spare,'char','b');
fwrite(fid,image.misc.scanOrientation,'char','b');
fwrite(fid,image.misc.flag1,'char','b');

% min and max voxel values
fwrite(fid,image.min,'double','b');
fwrite(fid,image.max,'double','b');

fwrite(fid,image.misc.origin,'double','b');
fwrite(fid,image.misc.pixvalOffset,'float','b');
fwrite(fid,image.misc.pixvalCal,'float','b');
fwrite(fid,image.misc.userDef1,'float','b');
fwrite(fid,image.misc.userDef2,'float','b');

% magic number, should be 719555000 for a gipl image
fwrite(fid,image.misc.magicNumber,'int','b');

% write data
image.data = permute(image.data,[2 1 3]);
fwrite(fid,image.data(:),'short','b');

fclose(fid);

