function [y,sigma]=addGaussNoise(x,dSNR)
%
% [y sigma]=addGaussNoise(x,dSNR)
%
% adds zero-mean Gaussian noise to a signal 'x' so that the desired SNR
% is 'dSNR' and returns the noisy signal in 'y', with the s.d. of the
% noise in 'sigma'
%

n  = randn(size(x));        % Generate N(0,1) noise

Px = sum(x(:).^2);          % Signal power
Pn = sum(n(:).^2);          % Noise power

K  = Px / (Pn * 10^(dSNR/10));               % Signal/Noise power ratio

n  = n * sqrt(K);           % Modify the noise

y  = x + n;                 % Noisy signal

sigma = std(n(:));

%
% Copyright (c) 2002, Nasir M. Rajpoot
%
