function [y0,y1]=cosWin(x,bsize)
%
% [y1 y2] = cosWin(x,bsize)
%
% returns the two raised-cosine-windowed signals 'y0' and 'y1'
% using the block size 'bsize', where 'y0' is of the size of 'x'
% and 'y1' is of the size of 'x' + bsize (padded with bsize/2
% zeros at the start and at the end.
%

%tstep = pi / (bsize-1);	% Divide the interval [0,pi] into
				% 'bsize' number of points

%t1 = pi/2:tstep:pi;
%w1 = cos(t1) .^ 2;		% cosine window (rising half)
%
%t2 = pi:tstep:3*pi/2;
%w2 = cos(t2) .^ 2;		% cosine window (falling half)

n       = length(x);
nBlocks = round (n / bsize);

if (nBlocks ~= n/bsize)
	error('Block size for overlap should be divisible by signal length ..');
end

nPeriod0 = nBlocks/2;
nPeriod1 = nPeriod0 + 1/2;

%tstep0   = (nPeriod0*2*pi)/(n-1);
tstep1   = (nPeriod1*2*pi)/(n+bsize-1);

t1 = 0:tstep1:nPeriod1*(2*pi);

w0 = sin(t1).^2;
w1 = cos(t1).^2;
w0 = w0( (bsize/2+1) : (n+bsize/2));

%%figure
%%subplot(121), plot(t0,w0);
%%subplot(122), plot(t1,w1);

%subplot(121), plot(w0);
%subplot(122), plot(w1);

y0 = w0 .* (reshape(x,[1 n]));
y1 = w1 .* ([zeros(1,bsize/2) reshape(x,[1 n]) zeros(1,bsize/2)]);



