function [x,xn,xd]=denoise3_LPyrThresh(dsnr,theta,nframes,x)
%
% [x,xn,xd] = denoise3_LPyrThresh(dsnr,theta,nframes,x)
%
% Denoising 3D image data using thresholding of the 3D Lapalcian
% Pyramid local FFT
%
% dsnr         --> Desired SNR of noisy image
% theta        --> threshold value ('soft' for adaptive)
% nframes      --> range of frames to display for comparison
% x (optional) --> image data (default: MissA sequence)
%

%*******************
if (nargin < 3)
	help denoise3_LPyrThresh
	error('Bad input arguments ..');
end

%*******************
nlev    = 3;
wSize   = [16 16 16];
%theta = sqrt(2*log(n)) * std(noise);

ptime   = 0.1;

%*******************

if (exist('x'))
	disp('Using the input 3-D data variable ''x'' ..');
else
	disp('Loading the 3D Miss America sequence ..');

	load missa_complete
	%x = y(10:265,80:335,23:150);
	x = y(80:207,155:282,23:150);
	x = double(x);
	clear y
end

%*******************
disp('Adding Gaussian white noise ..');

[xn,sigma] = addGaussNoise(x,dsnr);
disp(sprintf('sigma of the noisy image data is: %-6.2fdB ..',sigma));

%*******************
s0 = computeSNR(x,xn);
disp(sprintf('SNR of the noisy image data is: %-6.2fdB ..',s0));

%*******************
disp(sprintf('Computing %d-level 3D Laplacian pyramid ..',nlev));

pyr = computeLpyr3(xn,3);
% pyr = computeLpyr3(x,3);

%*******************
for k=1:nlev-1,
disp(sprintf('Band number: %d',k));
	bandK      = pyr{k};

str=sprintf('  Computing local FFT with [%d %d %d] window ..', ...
wSize(1),wSize(2),wSize(3));
disp(str);
	bandK_LFFT = computeLocalFFT3(bandK,wSize,0);
    disp('  Thresholding the local FFT ..');
    
    m=prod(size(bandK_LFFT));
    oct_abs=sort(reshape(abs(bandK_LFFT), 1, m));
            
            if (k == 1) % we are in hhh band
                %estimate the noise variance
                median=oct_abs(int16(m / 2));            
                noise_var = (median / 0.6745);
                %noise_var =m=prod(size(oct));
            end
            
	if (theta == 'soft')
		bandK_LFFT = softThresh3(bandK_LFFT,sigma);
        %bandK_LFFT = bayesShrink(bandK_LFFT,noise_var);
	else
		bandK_LFFT = hardThresh3(bandK_LFFT,theta);
	end
str=sprintf('  Computing inv. local FFT with [%d %d %d] window ..',...
wSize(1),wSize(2),wSize(3));
disp(str);
	bandK      = computeInvLocalFFT3(bandK_LFFT,wSize);

	pyr{k}     = real(bandK);
end

%*******************
disp(sprintf('Computing %d-level inverse 3D Laplacian pyramid ..',nlev));

xd = reconLpyr3(pyr);

%*******************
s1 = computeSNR(x,xd);
disp(sprintf('SNR of the denoised image data is: %-6.2fdB ..',s1));

%*******************
disp('Displaying one of the frames ..');

for k=nframes
	subplot(1,3,1);
	showImage3(x,k,1,0);
	title(sprintf('Original frame# %d',k));

	subplot(1,3,2);
	showImage3(xn,k,1,0);
	title(sprintf('Noisy frame# %d',k));

	subplot(1,3,3);
	showImage3(xd,k,1,0);
	title(sprintf('Denoised frame# %d',k));

	pause(ptime);
end

gtext(sprintf('SNR: Before --> %5.2fdB, After --> %5.2fdB',s0,s1));


%----------------------------------------------------------------

function yc=hardThresh3(xc,theta)

%
% yc=hardThresh3(xc,theta)
%
% Thresholds the 3D complex input 'xc' using threshold 'theta'
% (by equating to zero all inputs with magnitude below threshold)
% and returns the result in 'yc'
%
yc   = log(1+abs(xc));
mini = min(min(min(yc)));
maxi = max(max(max(yc)));

ind  = find(yc<theta);
pct  = length(ind)/length(xc(:)) * 100;

disp(sprintf('  [min=%f, max=%f, theta=%f] (%d%% coeffs below thr)',...
	min(min(min(yc))),...
	max(max(max(yc))), theta, round(pct)));

xc(ind) = 0;
yc = xc;


%----------------------------------------------------------------

function yc=softThresh3(xc,sigma)

%
% yc=softThresh3(xc,sigma)
%
% Soft thresholds the 3D complex input 'xc' using noise s.d.
% (by equating to zero all inputs with magnitude below threshold)
% and returns the result in 'yc'
%
% theta = sqrt(2*log(n)) * sigma
%
yc    = log(1+abs(xc));
mini  = min(min(min(yc)));
maxi  = max(max(max(yc)));
a=0.46;
%sigma
theta = sqrt(2*log(prod(size(xc))));
theta = theta * ( a*log10(sigma) + a*2 );
%theta = theta * 1.25
%theta = 0.75*maxi;

ind   = find(yc<theta);
pct   = length(ind)/length(xc(:)) * 100;

disp(sprintf('  [min=%f, max=%f, theta=%f] (%d%% coeffs below thr)',...
	min(min(min(yc))),...
	max(max(max(yc))), theta, round(pct)));

xc(ind) = 0;
yc = xc;

%------------------------------------
function yc=bayesShrink(xc, sigma)
m=prod(size(xc));
noise_var = sigma;
%showMovie (log(abs(xc)));
subband_std = std(xc(:));

sigma_subband = sqrt(max(subband_std ^ 2 - noise_var^2, 0));
beta=sqrt(log(m/3));
disp(sigma_subband);
if (sigma_subband ~= 0)
    %thresh = beta * ((noise_var^2) / (sigma_subband)) * (log(noise_var^2))*2*sqrt(2);
    thresh = (noise_var^2) / (sigma_subband)*beta ;
else
    thresh = max(abs(xc(:)))+1;
end 
disp(thresh);

%hard threshold
yc   = xc .* (abs(xc) > thresh);

