function [xn,xd]=denoise3_wavelab(x,dSNR)
%
% xd=denoise3_wavelab(x,dSNR)
%
% x     original image volume
%
% dSNR  desired SNR for the noisy (corrupted) version of the
%       original image volume
%

%*******************

disp('Adding white Gaussian noise ..');
[xn sigma] = addGaussNoise(x,dSNR);

%*******************

s0 = computeSNR(x,xn);
disp(sprintf('SNR of the noisy image data is: %-6.2fdB ..',s0));
disp(sprintf('sigma of the noisy image data is: %-6.2fdB ..',sigma));

%*******************

h = waitbar(0,'Please wait ..');
for k=1:size(xn,3)
	xd(:,:,k) = ThreshWave2(squeeze(xn(:,:,k)), 'S', 1, sigma);

	waitbar(k/size(xn,3),h);
end
disp(sprintf('denoised %f', computeSNR(xd, x)));
close(h);

