function [xi,xf,yi,yf,zi,zf]=getCubeIndices(m,n,p,winSize)
%
% [xi xf yi yf zi zf] = getCubeIndices(m,n,p,winSize)
%
% Returns the cube indices for (m,n,p)th cube in a volume
% where each cube (window) size is given by 'winSize'
%
% First Written by Nasir Rajpoot; 12/2002
%

xi = (m-1) * winSize(1) + 1;
xf = xi + winSize(1) - 1;

yi = (n-1) * winSize(2) + 1;
yf = yi + winSize(2) - 1;

zi = (p-1) * winSize(3) + 1;
zf = zi + winSize(3) - 1;

