function xr=iCosWin2d(y00,y01,y10,y11,bsize)
%
% xr=iCosWin2d(y00,y01,y10,y11,bsize)
%
% returns the original image 'xr' from the windowed versions
% y00,y01,y10,y11 using the block size 'bsize'
%
% where
%
% size(xr)  = [m       n]
%
% size(y00) = [m       n]
% size(y01) = [m+bsize n]
% size(y10) = [m       n+bsize]
% size(y11) = [m+bsize n+bsize]
%

nrows = size(y00,1);
ncols = size(y00,2);

x0 = y00 + y01(bsize/2+1:nrows+bsize/2, :);
x1 = y10 + y11(bsize/2+1:nrows+bsize/2, :);

xr = x0 + x1(:, bsize/2+1:ncols+bsize/2);


