function c=intertiaTensor(f,bsize)
%
% c=inertiaTensor(f)
%
% Second order moment (covariance matrix) of the 3-D local FFT
% (complex) of a volume block 'f' of the size 'bSize'; the result
% is returned in a 3x3 matrix 'c'
%

c = zeros(3,3);

for m=1:size(f,1)
	for n=1:size(f,2)
		for p=1:size(f,3)

			scoords = scaledCoords([m n p],bsize);	% scaled coords
          %  disp(scoords);
			w       = scoords' * scoords;		% weight matrix
			energy  = abs(f(m,n,p)) .^ 2;		% energy at point

			c = c + (energy * w);
		end
	end
end

c = c / prod(bsize);

