function [c,xi,yi,zi,A]=inertiaTensorLocal(xF,m,n,p,winSize,fname)
%
% [c,xi,yi,zi,A] = inertiaTensorLocal(xF,m,n,p,winSize,fname)
%
% Computes the local inertia tensor of the local FT 'xF'
% (computed presumably with 3D window size 'winSize')
%
% WARNING: No window overlap is used at the moment.
%
% First written by Nasir Rajpoot; 12/2002
%

xF_energy = sum(sum(sum(abs(xF).^2)));
verbose   = true;

[xi xf yi yf zi zf] = getCubeIndices(m, n, p, winSize);

bf = xF(xi:xf,yi:yf,zi:zf);
c  = inertiaTensor(bf,winSize);
% c = c/(sqrt(prod(winSize)))
c = c/(prod(winSize(1:2)));
A = sum(sum(sum(abs(bf).^2))) / xF_energy * 100.0;

writePars_Block(A,xi,yi,zi,c,fname);

%
function writePars_Block(A,xi,yi,zi,c,fname)
%
fid = fopen(fname,'a+b');

fprintf(fid,'A = %f\n',A);
fprintf(fid,'px,py,pz = \n%f, %f, %f\n', xi, yi, zi);
fprintf(fid,'Covariance matrix = \n');
fprintf(fid,'%f ', c(1,:));
fprintf(fid,'\n');
fprintf(fid,'%f ', c(2,:));
fprintf(fid,'\n');
fprintf(fid,'%f ', c(3,:));
fprintf(fid,'\n');

fclose(fid);

