function xi=reconLpyr3(pyr,nlev,filt2,edges)
%
% xi = reconLpyr3(pyr,nlev,filt2,edges)
%
% reconstructs the original 3D signal 'xi' from its 'nlev'
% levels Laplacian pyramid, given in the cell array 'pyr',
% using the filter 'filt2'
%

%************************
if (exist('nlev') ~= 1)
  nlev = size(pyr,2);
end

if (exist('filt2') ~= 1)
  filt2 = 'binom5';
end

if (exist('edges') ~= 1)
  edges= 'reflect1';
end

%************************
if (nlev ~= size(pyr,2))
	error('Bad number of levels ..');
	return
end

%************************
if isstr(filt2)
  filt2 = namedFilter(filt2);
end

if ( (size(filt2,1) > 1) & (size(filt2,2) > 1) )
  error('FILT2 should be a 1D filter (i.e., a vector)');
else
  filt2 = filt2(:);
end

len_f2  = length(filt2);
f2_dim1 = reshape(filt2, [len_f2 1 1]);
f2_dim2 = reshape(filt2, [1 len_f2 1]);
f2_dim3 = reshape(filt2, [1 1 len_f2]);

%************************
xi_sz = size(pyr{1});

if (nlev > 1)

  npyr = getNextPyramid(pyr);
  hi   = reconLpyr3(npyr, nlev-1, filt2, edges);
  
  int_sz1 = [size(pyr{1},1)  size(pyr{1},2)    size(pyr{1},3)/2];
  int_sz2 = [size(pyr{1},1)  size(pyr{1},2)/2  size(pyr{1},3)/2];

  hi = convUp3 (hi, f2_dim1, edges, [2 1 1], [1 1 1], int_sz2);
  hi = convUp3 (hi,  f2_dim2, edges, [1 2 1], [1 1 1], int_sz1);
  xi = convUp3 (hi,  f2_dim3, edges, [1 1 2], [1 1 1], xi_sz);

  xi = xi + pyr{1};

else
  
  xi = pyr{1};

end



%---------------------------------------------------

function npyr=getNextPyramid(pyr)

for k=2:size(pyr,2)
  npyr{k-1} = pyr{k};
end


