% xband_fft = showFFT_Lpyr3(xpyr, band_num, slice_range, pause_time)
%
% Display the FFT of a range of slices from the 3-d subband
% 'band_num' % (ordered from fine to coarse resolution) of a 
% Laplacian pyramid 'xpyr'
%
% The 3-d subband's FFT is optionally returned in 'xband'
%
% Written by Nasir Rajpoot, 11/02.

function xband_fft = showLpyr3(xpyr, band_num, slice_range, pause_time)

if (nargin < 2)
  disp('At least first two arguments should be provided ..');
  return
end

if ( (band_num < 0) | (band_num > length(xpyr)) )
  disp('Invalid pyramid subband number ..');
  return
end

%------------------------------------------------------------
%% OPTIONAL ARGS:
%------------------------------------------------------------

if (nargin < 3)
  slice_range = 1:length(pyr);
  pause_time  = 0.1;
end

if (nargin < 4)
  pause_time  = 0.1;
end

if (exist('filt1') ~= 1)
  filt1 = 'binom5';
end
 
%------------------------------------------------------------

xband = xpyr{band_num};
disp(sprintf('Taking the FFT of 3-d subband# %d of the pyramid ..',band_num));
xband_fft = fftshift(fftn(xband)); clear xband
xband_fft = abs(xband_fft);
disp('Displaying the abs of FFT ..');

for k=slice_range
	imagesc(squeeze(xband_fft(:,:,k)));
	colormap(gray(256));
	axis('image');
	title(sprintf('subband# %d: slice %d', band_num, k));
	drawnow;

	pause(pause_time);
end

