function coef = FPT3_WP(basis,img,qmf)
% FPT3_WP -- Analyze image into 3-d wavelet packet coefficients
%  Usage
%    coef = FPT3_WP(basis,img,qmf)
%  Inputs
%    basis    Oct Tree selecting wavelet packet basis
%    img      3-d image to be transformed into basis
%    qmf      quadrature mirror filter
%  Outputs
%    coef     3-d wavelet packet coeffts in given basis
%
%  Description
%    Once a wavelet packet basis has been selected (presumably via
%    Best2dBasis), this function may be used to expand a given
%    image in that basis.
%
	[n,J] = octlength(img);
	coef  = img;
%
% initialize tree traversal stack
%
	stack = zeros(4,8*(J+1)+1);
	k = 1;
	stack(:,k) = [0 0 0 0]'; % d, bx, by
%
	while(k > 0),

		% pop stack
		d = stack(1,k); 
		bx = stack(2,k); by = stack(3,k); bz=stack(4,k);
		k=k-1;
		%fprintf('d bx by'); disp([d bx by])

		if(basis(onode(d,bx,by,bz)) ~= 0) ,  % nonterminal node

			[lox hix loy hiy loz hiz] = octbounds(d,bx,by,bz,n);
			%fprintf('[lox hix loy hiy]'); disp([lox hix loy hiy])

			Oct = coef(lox:hix,loy:hiy,loz:hiz);
			oct = DownOct(Oct,qmf,bx,by,bz);
			coef(lox:hix,loy:hiy,loz:hiz) = oct;

			% push stack
			k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by)   (2*bz)]';
			k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by)   (2*bz)]';
			k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by+1) (2*bz)]';
			k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by+1) (2*bz)]';
            
			k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by)   (2*bz+1)]';
			k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by)   (2*bz+1)]';
			k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by+1) (2*bz+1)]';
			k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by+1) (2*bz+1)]';
		end
	end

%
% Copyright (c) 1993. David L. Donoho
% 
    
% Modified 2003, Zhen Yao
    
%   
% Part of WaveLab Version 802
% Built Sunday, October 3, 1999 8:52:27 AM
% This is Copyrighted Material
% For Copying permissions see COPYING.m
% Comments? e-mail wavelab@stat.stanford.edu
%   
    
