function img = IPT3_WP(basis,coef,qmf)
% IPT2_WP -- Synthesize image from 3-d wavelet packet coefficients
%  Usage
%    img = IPT3_WP(btree,coef,qmf)
%  Inputs
%    btree    Quad Tree indicating wavelet packet to use
%    coef     2-d wavelet packet coeffts in given basis
%    qmf      quadrature mirror filter
%  Outputs
%    img      2-d image whose 2-d wavelet packet coefft's in
%             basis are coef
%  Description
%    Perform the inverse operation of FPT2_WP.
%
	[n,J] = octlength(coef);
	img   = coef;


	% initialize tree traversal stack
	stack = zeros(5,8*(J+1)+1);
	k = 1;
	stack(:,k) = [0 0 0 0 0]'; % d, bx, by, bz, unmarked
%
	while(k > 0),

		% pop stack
		d = stack(1,k); 
		bx = stack(2,k); by = stack(3,k); bz=stack(4,k);
		marked = stack(5,k); k=k-1;
		% fprintf('d bx by'); disp([d bx by])

		if(basis(onode(d,bx,by,bz)) ~= 0) ,  % nonterminal node

		   if(marked == 0),

				% first visit, because unmarked
				% pushdown (marked) self
				% pushdown unmarked children

				k = k+1; stack(:,k) = [d bx by bz 1]';
				k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by)   (2*bz) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by)   (2*bz) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by+1) (2*bz) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by+1) (2*bz) 0]';
                
                k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by)   (2*bz+1) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by)   (2*bz+1) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by+1) (2*bz+1) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by+1) (2*bz+1) 0]';
		   else

				% second (&last) visit, because marked
				% reconstruct -- apply UpOct operator

				[lox hix loy hiy loz hiz] = octbounds(d,bx,by,bz,n);
				%fprintf('[lox hix loy hiy]'); disp([lox hix loy hiy])

				oct = img(lox:hix,loy:hiy,loz:hiz);
				Oct = UpOct(oct,qmf,bx,by,bz);
				img(lox:hix,loy:hiy,loz:hiz) = Oct;
		   end         

		end
	end

%
% Copyright (c) 1993. David L. Donoho
% 
    
% Modified 2003, Zhen Yao    

%   
% Part of WaveLab Version 802
% Built Sunday, October 3, 1999 8:52:27 AM
% This is Copyrighted Material
% For Copying permissions see COPYING.m
% Comments? e-mail wavelab@stat.stanford.edu
%   
    
