function btree=Make3dBasis(depth,btype)
%
% btree = Make3dBasis(depth, btype)
%
% Returns the basis tree for the basis of the type 'btype'
%

btree = zeros(1, 2*(8^depth));

if (strcmp(btype,'Wavelet'))
	for d=0:depth-1
		on = onode(d,0,0,0);	% DC band at level 'd'

		btree(on) = 1;
	end
elseif (strcmp(btype,'Gabor'))
	for d=0:depth-1
		for i=0:2^d-1
		for j=0:2^d-1
		for k=0:2^d-1
			on = onode(d,i,j,k);	% subband at level 'd'

			btree(on) = 1;
		end
		end
		end
	end
end
