function ix = onode(d,bx,by,bz)
% onode -- Oct tree indexing
%  Usage
%    ix = onode(d,bx,by,bz)
%  Inputs
%    d          depth in splitting
%    bx,by,bz   coordinates at that depth
%  Outputs
%    ix      index of that node in tree
%
%  Description
%    OLD-2D: ix = 4^(d) + by + bx*2^(d)
%    ix = 8^(d) + by + bx*2^(d) + bz*4^(d)
    ix = 8^(d) + by + bx*2^(d) + bz*4^(d);
    
    
% Modified 2003, Zhen Yao

%   
% Part of WaveLab Version 802
% Built Sunday, October 3, 1999 8:52:27 AM
% This is Copyrighted Material
% For Copying permissions see COPYING.m
% Comments? e-mail wavelab@stat.stanford.edu
%   
    
