% showImage3(x, frame_range, info_flag, pause_time)
%
% Display a range of frames from a 3-d sequence/volume
% 'x' with 'pause_time' (default 0.1) secs between any
% two frames
%
% Set 'info_flag' to 1, if you would like to see the
% min,max,ave information about each frame
%
% Written by Nasir Rajpoot, 11/02.

function showImage3(x, frame_range, info_flag, pause_time)

if (nargin < 1)
  disp('At least first argument should be provided ..');
  return
end

%------------------------------------------------------------
%% OPTIONAL ARGS:
%------------------------------------------------------------

if (nargin < 2)
  frame_range = 1:size(x,3);
  info_flag   = 0;
  pause_time  = 0.1;
end

if (nargin < 3)
  info_flag   = 0;
  pause_time  = 0.1;
end

if (nargin < 4)
  pause_time  = 0.1;
end

%------------------------------------------------------------

for k=frame_range
	xframe = squeeze(x(:,:,k));
	if (info_flag)
		disp(sprintf('frame# --> %3d: min=%f, max=%f, ave=%f', k, min(min(xframe)), max(max(xframe)), mean(mean(xframe))));
	end
	imagesc(xframe);
	colormap(gray(256));
	axis('image');
	title(sprintf('frame# %d', k));
	drawnow;

	pause(pause_time);
end

