function q = DownOct(Oct,qmf,xbit,ybit,zbit)
% DownOct -- Split 3-d image into 8 subbands
%  Usage
%    q = DownOct(Oct,qmf,xbit,ybit,zbit)
%  Inputs
%    Oct    Octlet to be split into four subbands 
%    qmf    orthogonal quadrature mirror filter  
%    xbit   x-position of octlet in 3-d freq plane
%    ybit   y-position of octlet in 3-d freq plane
%    zbit   z-position of octlet in 3-d freq plane
%  Outputs
%    q      octlet after splitting
%
%  Description
%    A 3-d signal is split into four subbands: (Lo_x,Lo_y, Lo_z),
%    (Lo_x,Hi_y, Lo_z), (Hi_x,Lo_y, Lo_z), (Hi_x,Hi_y, Lo_z),
%    (Lo_x, Lo_y, Hi_z),(Lo_x,Hi_y, Hi_z), 
%    (Hi_x,Lo_y, Hi_z), (Hi_x,Hi_y, Hi_z),
%
%    This routine is called by other, higher-level WaveLab functions
%    and may not be useful for many users.
%
%  See Also
%    FPT3_WP, UpOct
%

	[nr,nc,nt] = size(Oct);
	q    = zeros(nr,nc,nt);
	ybit = rem(ybit,2);
	xbit = rem(xbit,2);
        zbit=rem(zbit, 2);
%
	bot = 1:(nc/2);
	top = bot + (nc/2);
%
        for t=1:nt,
  	    for i=1:nr,
		lpchan = DownDyadLo(Oct(i,:, t),qmf);
		hpchan = DownDyadHi(Oct(i,:, t),qmf);

		if xbit,
		    q(i,top,t) = lpchan;
		    q(i,bot,t) = hpchan;
		else
		    q(i,top,t) = hpchan;
		    q(i,bot,t) = lpchan;
		end
            end
	end
%
	bot = 1:(nr/2);
	top = bot + (nr/2);
%
	for t=1:nt,
	   for j=1:nc,
		lpchan = DownDyadLo(q(:,j, t)',qmf)';
		hpchan = DownDyadHi(q(:,j, t)',qmf)';

		if ybit,
		    q(top,j, t) = lpchan;
		    q(bot,j, t) = hpchan;
		else
		    q(top,j,t) = hpchan;
		    q(bot,j,t) = lpchan;
		end
            end
	end
    
  	bot = 1:(nt/2);
	top = bot + (nt/2);
%
	for i=1:nc,
	   for j=1:nr,
   		lpchan = DownDyadLo(reshape(q(i,j, :),1,nt),qmf);
		hpchan = DownDyadHi(reshape(q(i,j,:),1, nt),qmf);
        
		if zbit,
		    q(i,j, top) = lpchan;%reshape(lpchan, 1, 1, nt);
		    q(i,j, bot) = hpchan;%reshape(hpchan, 1, 1, nt);
		else
		    q(i,j,top) = hpchan;%reshape(hpchan, 1, 1, nt);
		    q(i,j,bot) = lpchan;%reshape(lpchan, 1, 1, nt);;
		end
      end
	end
     


% Modified 2003, Zhen Yao

%   
% Part of WaveLab Version 802
% Built Sunday, October 3, 1999 8:52:27 AM
% This is Copyrighted Material
% For Copying permissions see COPYING.m
% Comments? e-mail wavelab@stat.stanford.edu
%   
    
