function Q = UpOct(oct,qmf,xbit,ybit,zbit)
% UpOct -- Merge four subbands into 2d image
%  Usage
%    Q = UpOct(oct,qmf,xbit,ybit,zbit)
%  Inputs
%    oct    octlet to be joined 8->1 channel 
%    qmf    orthogonal quadrature mirror filter  
%    xbit   x-position of octlet in 3-d freq plane
%    ybit   y-position of octlet in 3-d freq plane
%    zbit   z-position of octlet in 3-d freq plane
%  Outputs
%    q      octlet after splitting
%
%  Description
%    A 3-d signal split into eight channels: is unsplit
%    into original image.
%
%    This routine is called by other, higher-level WaveLab
%    functions and may not be useful for many users.
%
%  See Also
%    IPT3_WP, DownOct
%
	[nr,nc,nt] = size(oct);
	Q    = zeros(nr,nc,nt);
	ybit = rem(ybit,2);
	xbit = rem(xbit,2);
    zbit = rem(zbit,2);
%
	bot = 1:(nt/2);
	top = bot + (nt/2);
%
    for i=1:nc,
	  for j=1:nr,
        
		if zbit,
		    lpchan = reshape(oct(i,j,top), 1, nt/2);
			hpchan = reshape(oct(i,j,bot), 1, nt/2);
		else
		    lpchan = reshape(oct(i,j,bot),1, nt/2);
			hpchan = reshape(oct(i,j,top),1, nt/2);
		end

		Q(i,j,:) = UpDyadLo(lpchan,qmf) + UpDyadHi(hpchan,qmf);
      end
	end
%
    
%
	bot = 1:(nr/2);
	top = bot + (nr/2);
%
    for t=1:nt,
	  for j=1:nc,
		if ybit,
		    lpchan = Q(top,j,t)';
			hpchan = Q(bot,j,t)';
		else
		    lpchan = Q(bot,j,t)';
			hpchan = Q(top,j,t)';
		end

		Q(:,j,t) = UpDyadLo(lpchan,qmf)' + UpDyadHi(hpchan,qmf)';
      end
	end
%

	bot = 1:(nc/2);
	top = bot + (nc/2);
%
   for t=1:nt,
     for i=1:nr,
		if xbit,
		    lpchan = Q(i,top,t);
			hpchan = Q(i,bot,t);
		else
		    lpchan = Q(i,bot,t);
			hpchan = Q(i,top,t);
		end

		Q(i,:,t) = UpDyadLo(lpchan,qmf) + UpDyadHi(hpchan,qmf);
      end
	end
%
    
% Modified 2003, Zhen Yao
    
%   
% Part of WaveLab Version 802
% Built Sunday, October 3, 1999 8:52:27 AM
% This is Copyrighted Material
% For Copying permissions see COPYING.m
% Comments? e-mail wavelab@stat.stanford.edu
%   
    
