function img = bayesThreshold1(basis, coef, sigma, l)
% bayesThreshold -- BayesShrink the 3-d wavelet packet coefficients
%  Usage
%    img = bayesThreshold(basis, coef, sigma, l)
%  Inputs
%    basis    Quad Tree indicating wavelet packet to use
%    coef     3-d wavelet packet coeffts in given basis
%    sigma    Standard deviation of noise level
%    l        Number of wavelet decompositions
%  Outputs
%    img      3-d thresholded wavelet coefficient.
%  Description
%    
%

	[n,J] = octlength(coef);
	img   = coef;

	% initialize tree traversal stack
	stack = zeros(6,8*(J+1)+1);
	k = 1;
	stack(:,k) = [0 0 0 0 0 0]'; % d, bx, by, bz, unmarked, user reserved
%
	while(k > 0),

		% pop stack
		d = stack(1,k); 
		bx = stack(2,k); by = stack(3,k); bz=stack(4,k);
		marked = stack(5,k); 
        pos = stack(6, k); k=k-1;
		% fprintf('d bx by'); disp([d bx by])
        
		if(basis(onode(d,bx,by,bz)) ~= 0) ,  % nonterminal node

		   if(marked == 0),

				% first visit, because unmarked
				% pushdown (marked) self
				% pushdown unmarked children

				k = k+1; stack(:,k) = [d bx by bz 1, pos]';
				k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by)   (2*bz) 0 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by)   (2*bz) 0 1]';
				k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by+1) (2*bz) 0 2]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by+1) (2*bz) 0 3]';
                
                k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by)   (2*bz+1) 0 4]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by)   (2*bz+1) 0 5]';
				k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by+1) (2*bz+1) 0 6]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by+1) (2*bz+1) 0 7]'; % This is the hhh-band
            end
        else  % terminal node, 
            [lox hix loy hiy loz hiz] = octbounds(d,bx,by,bz,n);
            oct = img(lox:hix,loy:hiy,loz:hiz);
            
            m=prod(size(oct));
            oct_abs=sort(reshape(abs(oct), 1, m));
            
            if (pos == 7) % we are in hhh band
                % Estimate the noise variance using a Median filter.
                median=oct_abs(int16(m / 2));
                noise_var = (median / 0.6745);
               % noise_var = std(oct(:));
           end

           % If set to adaptive, then use the estimation,
           % otherwise use given sigma.
           % Adaptive is not recommended, since on some HHH bands the 
           % estimation is far from accurate.  It is recommended to 
           % estimate the sigma using estimateNoise function to get a 
           % robust estimation.
           if (sigma ~='adaptive')
               noise_var=sigma;
           end
           
           subband_std = std(oct(:));
            
            sigma_subband = sqrt(max(subband_std ^ 2 - noise_var^2, 0));
            % Biased with the level of decomposition.
            beta=sqrt(log(m/l));
            
            if (sigma_subband ~= 0)
               
                thresh = (noise_var^2) / (sigma_subband) ;
            else
                % Set the threshold to remove everything
                thresh = max(oct(:))+1;
            end           
            %disp(thresh);
            %Use hard threshold
            img(lox:hix,loy:hiy,loz:hiz) = HardThresh(oct,thresh);
        end
    end
