function inv = denoise_wp_bayes(xc, btree, level, qmf, sigma)
%  denoise_wp_bayes -- Bayesian denoising on 3D-WP 
%               
%  Usage
%    out = denoise_wp_bayes(xc, btree, level, qmf, sigma)
%  Inputs
%    xc         Noisy image.
%    btree      Oct Tree Decomposition information
%    level      Deepness of decomposition.
%    qmf        Quadrature Mirror Filter for Wavelet Transform
%    sigma      Standard deviation of noise.
%  Outputs
%    out        Restored image.
%  See Aslo
%    estimateNoise

disp('forward transform');
coef=FPT3_WP(btree, xc, qmf);
dc=keepDC(btree, coef);
c=removeDC(btree, coef);
if (strcmpi(sigma, 'robust'))
	sigma=estimateNoise(btree, c);
end
disp('thresholding...');
t=bayesThreshold(btree, c, sigma, level);
disp('reconstructing...');
inv = IPT3_WP(btree, t+dc, qmf);
