function sigma = estimateNoise(basis,coef)
% bayesThreshold -- Estimate the noise level via second order median filter
% 
%  Usage
%    sigma = estimateNoise(basis,coef)
%  Inputs
%    basis    Oct Tree indicating wavelet packet to use
%    coef     3-d wavelet packet coeffts in given basis
%  Outputs
%    sigma    The estimated noise level.
%  Description
%    Estimate the noise level via second order median filter
%
	[n,J] = octlength(coef);
	img   = coef;
        sigma_array = [];

	% initialize tree traversal stack
	stack = zeros(6,8*(J+1)+1);
	k = 1;
	stack(:,k) = [0 0 0 0 0 0]'; % d, bx, by, bz, unmarked, user reserved
%
	while(k > 0),

		% pop stack
		d = stack(1,k); 
		bx = stack(2,k); by = stack(3,k); bz=stack(4,k);
		marked = stack(5,k); 
        pos = stack(6, k); k=k-1;
		% fprintf('d bx by'); disp([d bx by])
        
		if(basis(onode(d,bx,by,bz)) ~= 0) ,  % nonterminal node

		   if(marked == 0),

				% first visit, because unmarked
				% pushdown (marked) self
				% pushdown unmarked children

				k = k+1; stack(:,k) = [d bx by bz 1, pos]';
				k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by)   (2*bz) 0 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by)   (2*bz) 0 1]';
				k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by+1) (2*bz) 0 2]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by+1) (2*bz) 0 3]';
                
                k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by)   (2*bz+1) 0 4]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by)   (2*bz+1) 0 5]';
				k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by+1) (2*bz+1) 0 6]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by+1) (2*bz+1) 0 7]'; % This is the hhh-band
            end
        else  % terminal node, 
            [lox hix loy hiy loz hiz] = octbounds(d,bx,by,bz,n);
            oct = img(lox:hix,loy:hiy,loz:hiz);
            
            m=prod(size(oct));
            oct_abs=sort(reshape(abs(oct), 1, m));
            
            if (pos == 7) % we are in hhh band
                %estimate the noise variance
                median=oct_abs(int16(m / 2));
                noise_var = (median / 0.6745);
                sigma_array(end+1) = noise_var;
            end
            
        end
    end

sigma_array=sort(sigma_array);
%sigma_array
sigma=mean(sigma_array(2:floor(end/2)));
