function img = keepDC(basis,coef)
% keepDC -- Keep only the DC(lowpass band) of the 3-d wavelet 
%           packet coefficients
%  Usage
%    img = keepDC(btree,coef)
%  Inputs
%    btree    Oct Tree indicating wavelet packet to use
%    coef     3-d wavelet packet coeffts in given basis
%  Outputs
%    img      Lowpass  wavelet coefficient.
%  Description
%    Keep only the DC(lowpass band) of the 3-d wavelet 
%
	[n,J] = octlength(coef);
	img   = zeros(size(coef));

	% initialize tree traversal stack
	stack = zeros(5,8*(J+1)+1);
	k = 1;
	stack(:,k) = [0 0 0 0 0]'; % d, bx, by, bz, unmarked
    count=1;
%
	while(k > 0),

		% pop stack
		d = stack(1,k); 
		bx = stack(2,k); by = stack(3,k); bz=stack(4,k);
		marked = stack(5,k); k=k-1;
		% fprintf('d bx by'); disp([d bx by])

		if(basis(onode(d,bx,by,bz)) ~= 0) ,  % nonterminal node

		   if(marked == 0),

				% first visit, because unmarked
				% pushdown (marked) self
				% pushdown unmarked children

				k = k+1; stack(:,k) = [d bx by bz 1]';
				k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by)   (2*bz) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by)   (2*bz) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by+1) (2*bz) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by+1) (2*bz) 0]';
                
                k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by)   (2*bz+1) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by)   (2*bz+1) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by+1) (2*bz+1) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by+1) (2*bz+1) 0]';
            end
        else  % terminal node, 
            if (bx == 0 && by == 0 && bz == 0)     % DC band
                [lox hix loy hiy loz hiz] = octbounds(d,bx,by,bz,n);
                img(lox:hix,loy:hiy,loz:hiz) = coef(lox:hix,loy:hiy,loz:hiz);
            end            
        end
    end
