function [lox,hix,loy,hiy, loz, hiz] = octbounds(d,bx,by,bz,n)
% octbounds -- x,y,z bounds of octlet
%  Usage
%    [lox,hix,loy,hiy,loz,hiz] = octbounds(d,bx,by,bz,n)
%  Inputs
%    d          depth in splitting
%    bx,by,bz   box coordinates at that depth
%    n          extent of image
%  Outputs
%    lox     lower x-index of octlet
%    loy     lower y-index of octlet
%    loz     lower z-index of octlet
%    hix     upper x-index of octlet
%    hiy     upper y-index of octlet
%    hiz     upper z-index of octlet
%    
%
%  Description
%    This routine is called by other, higher-level Wavelab functions
%    and is not intended to be useful for most users.
%

    boxsize = n/(2^d);
    lox = bx*boxsize+1;
    loy = by*boxsize+1;
    loz = bz*boxsize+1;
    hix = (bx+1)*boxsize;
    hiy = (by+1)*boxsize;
    hiz = (bz+1)*boxsize;
    
% Modified 2003, Zhen Yao
    
%   
% Part of WaveLab Version 802
% Built Sunday, October 3, 1999 8:52:27 AM
% This is Copyrighted Material
% For Copying permissions see COPYING.m
% Comments? e-mail wavelab@stat.stanford.edu
%   
    
