% Wavelet decomposition
% author: Zhen Yao
% ------------------------

function p = psnr(img1, img2)
% PSNR metric.
[a,b]=size(img1);
[a1,b1]=size(img2);
x=reshape(img1, 1, a*b);
y=reshape(img2, 1, a1*b1);
mse=0;
for i=1:a*b,
    mse = (x(1,i) - y(1,i))^2 + mse;
end
p = 20 * log10(255/ sqrt(mse));
