function img = sureThreshold(basis,coef,sigma)
% sureThreshold -- SURE threshold the 3-d wavelet packet coefficients
%  Usage
%    img = sureThreshold(basis,coef, sigma)
%  Inputs
%    basis    Oct Tree indicating wavelet packet to use
%    coef     3-d wavelet packet coeffts in given basis
%    sigma    Standard deviation of the noise level.
%  Outputs
%    img      3-d thresholded wavelet coefficient.
%  Description
%    3D WP SURE Thresholding
%
	[n,J] = octlength(coef);
	img   = coef;

	% initialize tree traversal stack
	stack = zeros(5,8*(J+1)+1);
	k = 1;
	stack(:,k) = [0 0 0 0 0]'; % d, bx, by, bz, unmarked
%
	while(k > 0),

		% pop stack
		d = stack(1,k); 
		bx = stack(2,k); by = stack(3,k); bz=stack(4,k);
		marked = stack(5,k); k=k-1;
		% fprintf('d bx by'); disp([d bx by])

		if(basis(onode(d,bx,by,bz)) ~= 0) ,  % nonterminal node

		   if(marked == 0),

				% first visit, because unmarked
				% pushdown (marked) self
				% pushdown unmarked children

				k = k+1; stack(:,k) = [d bx by bz 1]';
				k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by)   (2*bz) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by)   (2*bz) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by+1) (2*bz) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by+1) (2*bz) 0]';
                
                k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by)   (2*bz+1) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by)   (2*bz+1) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx)   (2*by+1) (2*bz+1) 0]';
				k = k+1; stack(:,k) = [(d+1) (2*bx+1) (2*by+1) (2*bz+1) 0]';
            end
        else  % terminal node, 
            [lox hix loy hiy loz hiz] = octbounds(d,bx,by,bz,n);
            oct = img(lox:hix,loy:hiy,loz:hiz);
            [x1,y1,z1]=size(oct);
            oct=reshape(oct, 1,x1*y1*z1);
            std_oct=std(oct);
            if (std_oct ~= 0)
                img(lox:hix,loy:hiy,loz:hiz) = reshape(SUREThresh(oct/std_oct),x1,y1,z1)*std_oct;
            end
            
        end
    end

function yc=softThresh3(xc,sigma,a,s)

%
% yc=softThresh3(xc,sigma)
%
% Soft thresholds the 3D complex input 'xc' using noise s.d.
% (by equating to zero all inputs with magnitude below threshold)
% and returns the result in 'yc'
%
% theta = sqrt(2*log(n)) * sigma
%
yc    = log(1+abs(xc));
mini  = min(min(min(yc)));
maxi  = max(max(max(yc)));

%sigma
theta = sqrt(2*log(prod(size(xc))));
theta = theta*s * ( a*log10(sigma) + 2*a);
%theta = theta * 1.25
%theta = 0.75*maxi;

ind   = find(yc<theta);
pct   = length(ind)/length(xc(:)) * 100;

%disp(sprintf('  [min=%f, max=%f, theta=%f] (%d%% coeffs below thr)',...
%	min(min(min(yc))),...
%	max(max(max(yc))), theta, round(pct)));

xc(ind) = 0;
yc = xc;


%
% Copyright (c) 1993. David L. Donoho
% 
    
% Modified 2003, Zhen Yao    

%   
% Part of WaveLab Version 802
% Built Sunday, October 3, 1999 8:52:27 AM
% This is Copyrighted Material
% For Copying permissions see COPYING.m
% Comments? e-mail wavelab@stat.stanford.edu
%   
    
