#include "straighten_log.h"

int STRAIGHTEN_LOGGING_INDENT = 3;

static int32_t STRAIGHTEN_LOG_LEVEL = 2;

static int32_t STRAIGHTEN_DEBUG = 0;

static int32_t STRAIGHTEN_LOG_DISPLAY = 1;

static const char * straighten_log_level_names[] = { "V.V-INFO", "V-INFO", "INFO", "WARNING", "ERROR", "FATAL"};
static const char * straighten_log_level_initials[] = { "VV", "V", "I", "W", "E", "F"};
static const char * straighten_log_level_colors[] = { ANSI_COLOR_CYAN, ANSI_COLOR_CYAN, ANSI_COLOR_GREEN, ANSI_COLOR_YELLOW, ANSI_COLOR_RED, ANSI_COLOR_RED};

void straighten_set_log_level(int log_level) {
	STRAIGHTEN_LOG_LEVEL = log_level;
}

void straighten_set_debug(int debug) {
	STRAIGHTEN_DEBUG = debug;
}

void straighten_set_log_display(int display) {
	STRAIGHTEN_LOG_DISPLAY = display;

	if(display == 0) {
		STRAIGHTEN_LOGGING_INDENT = 0;		
	}
	else if(display == 1){
		STRAIGHTEN_LOGGING_INDENT = 3;
	}
	else if(display == 2){
		STRAIGHTEN_LOGGING_INDENT = 9;
	}
	else {
		STRAIGHTEN_LOGGING_INDENT = 9;
	}
}

void _straighten_log(const char * file, const char * function, const int line, int log_level, const char *fmt, ...) {
	if(log_level < STRAIGHTEN_LOG_LEVEL) {
		return;
	}

	if(STRAIGHTEN_LOG_DISPLAY == 1) {
		fprintf(stdout, "%s%2s\x1b[0m ", straighten_log_level_colors[log_level], straighten_log_level_initials[log_level]);
	}
	else if(STRAIGHTEN_LOG_DISPLAY != 0) {
		fprintf(stdout, "%s%8s\x1b[0m ", straighten_log_level_colors[log_level], straighten_log_level_names[log_level]);
	}
	
	va_list args;
	va_start(args, fmt);
    vfprintf(stdout, fmt, args);
    va_end(args);

    if(STRAIGHTEN_DEBUG) {
		fprintf(stdout, " \x1b[90m%s(%s):%d\x1b[0m ", file, function, line);
	}

    fprintf(stdout, "\n");
    fflush(stdout);
}
