package lrc;

import java.awt.*;
import java.awt.geom.*;
import javax.swing.*;
import java.util.*;


/**
 * This is the main display panel.
 * @author ciken
 * 
 */
public class FlowPanel extends JPanel {
	private static final long serialVersionUID = 95446753457828474L;

	public Flow f;
	public Vector<Integer> lambda,mu,nu;
	public Vector<Turn> path = null;
	public boolean draw = false;
	public int iteration = 0;
	public String label = "";

	public FlowPanel() {
		this.f=null;
		setBackground(Color.WHITE);
	}

	private static final double graphicsoffseti = 330;//first coordinate of the top vertex of the triangular graph
	private static final double graphicsoffsetj = 50;//second coordinate of the top vertex of the triangular graph
	private double graphicsscale() {
		return 500/((f.n+1)*0.866);
	}
	private static final int vertexRadius = 7;
	//AWT first coordinate: ---> left to right
	//AWT second coordinate: v top to bottom
	private Point rowAndColumn2AWTCoord(RowAndColumn rc) {
		double i=rc.col;
		double j=rc.row;
		double I = graphicsscale()*i;
		double J = graphicsscale()*j;
		I = I-J*0.5;
		J = J *-0.866;
		J = -J;
		I+=graphicsoffseti;
		J+=graphicsoffsetj;
		return new Point((int)I,(int)J);
	}

	
	/**
	 * method written by
	 * Michael Zlatkovsky, Mar 26 2011 at 23:59,
	 * http://stackoverflow.com/questions/2027613/how-to-draw-a-directed-arrow-line-in-java
	 */
	public static Shape createArrowShape(Point fromPt, Point toPt) {
		Polygon arrowPolygon = new Polygon();
		arrowPolygon.addPoint(-6,1);
		arrowPolygon.addPoint(0,1);
		arrowPolygon.addPoint(0,4);
		arrowPolygon.addPoint(6,0);
		arrowPolygon.addPoint(0,-4);
		arrowPolygon.addPoint(0,-1);
		arrowPolygon.addPoint(-6,-1);
		
		Point midPoint = new Point((fromPt.x+toPt.x)/2,(fromPt.y+toPt.y)/2);
		
		double rotate = Math.atan2(toPt.y - fromPt.y, toPt.x - fromPt.x);
		
		AffineTransform transform = new AffineTransform();
		transform.translate(midPoint.x, midPoint.y);
		double ptDistance = fromPt.distance(toPt);
		double scale = ptDistance / 12.0; // 12 because it's the length of the arrow polygon.
		transform.scale(scale, scale);
		transform.rotate(rotate);
		
		return transform.createTransformedShape(arrowPolygon);
	}
	
	@Override
	public void paint(Graphics g) {
		if (iteration==-1) {
			setBackground(Color.getHSBColor(0, 0, 0.9f));//light gray
		} else {
			setBackground(Color.WHITE);
		}
		super.paint(g);
		if (!draw) return;
        Graphics2D g2 = (Graphics2D) g;

		long stepsize = (long)Math.pow(2, iteration);
        
        if (f!=null) {
			//<side labels>
			{
				g.setColor(Color.BLACK);
				g.drawString("lambda", 550, 150);
				g.drawString("mu", 320, 560);
				g.drawString("nu", 100, 150);
			}
			//</side labels>

			//<step size label>
			{
				if (iteration>=0) {
					g.setColor(Color.BLACK);
					Font oldFont = g.getFont();
					Font fo = oldFont.deriveFont(20.0f);
					g.setFont(fo);
					g.drawString("step size = "+stepsize, 50, 35);
					g.setFont(oldFont);				
				}
			}
			//</step size label>

			//<"done" label>
			{
				if (iteration==-1) {
					g.setColor(Color.BLACK);
					Font oldFont = g.getFont();
					Font fo = oldFont.deriveFont(Font.BOLD);
					fo = fo.deriveFont(20.0f);
					g.setFont(fo);
					String s = "LR-coefficient is zero.";
//					if (LRCPositivity.isCertificate(f, nu)) s = "positive LR-coefficient.";
					if (LRCPositivity.isCertificate(f, nu)) s = label;
					g.drawString(s, 50, 35);
					g.setFont(oldFont);				
				}
			}
			//</"done" label>
			
			//<fat degeneracy graph when at throughput limit>
			{
				Stroke oldStroke = g2.getStroke();
				g2.setStroke(new BasicStroke(5));
				for (int i=0;i<f.n;i++) {
					ThroughputPosition tp = new ThroughputPosition(new RowAndColumn(i, i),HexagonalDirection.UPRIGHT5);
					long throughput = -f.get(tp);
					Point p1 = rowAndColumn2AWTCoord(tp.vertex);
					Point p2 = rowAndColumn2AWTCoord(tp.secondVertex());
					if (throughput == lambda.get(i)) {
						g.setColor(Color.BLACK);
						g.drawLine(p1.x, p1.y, p2.x, p2.y);
					} else if (throughput+stepsize > lambda.get(i)) {
						g.setColor(Color.LIGHT_GRAY);
						g.drawLine(p1.x, p1.y, p2.x, p2.y);
					}
				}
				for (int i=0;i<f.n;i++) {
					ThroughputPosition tp = new ThroughputPosition(new RowAndColumn(f.n, i),HexagonalDirection.UP3);
					long throughput = f.get(tp);
					Point p1 = rowAndColumn2AWTCoord(tp.vertex);
					Point p2 = rowAndColumn2AWTCoord(tp.secondVertex());
					if (throughput == mu.get(f.n-i-1)) {
						g.setColor(Color.BLACK);
						g.drawLine(p1.x, p1.y, p2.x, p2.y);
					} else if (throughput+stepsize > mu.get(f.n-i-1)) {
						g.setColor(Color.LIGHT_GRAY);
						g.drawLine(p1.x, p1.y, p2.x, p2.y);
					}
				}
				for (int i=0;i<f.n;i++) {
					ThroughputPosition tp = new ThroughputPosition(new RowAndColumn(i, 0),HexagonalDirection.DOWNRIGHT7);
					long throughput = -f.get(tp);
					Point p1 = rowAndColumn2AWTCoord(tp.vertex);
					Point p2 = rowAndColumn2AWTCoord(tp.secondVertex());
					if (throughput == nu.get(i)) {
						g.setColor(Color.BLACK);
						g.drawLine(p1.x, p1.y, p2.x, p2.y);
					} else if (throughput+stepsize > nu.get(i)) {
						g.setColor(Color.LIGHT_GRAY);
						g.drawLine(p1.x, p1.y, p2.x, p2.y);
					}
				}
				g2.setStroke(oldStroke);
			}
			//</fat degeneracy graph when at throughput limit>

			//<vertices of the triangular grid>
			{
				g.setColor(Color.DARK_GRAY);
				for (int row=0;row<=f.n;row++) {
					for (int col=0;col<=row;col++) {
						Point p = rowAndColumn2AWTCoord(new RowAndColumn(row, col));
						g.fillOval(p.x-vertexRadius/2,p.y-vertexRadius/2,vertexRadius,vertexRadius);
					}
				}
			}
			//</vertices of the triangular grid>
			
			//<degeneracy graph>
			{
				g.setColor(Color.DARK_GRAY);
				for (int row=0;row<f.n;row++) {
					for (int col=0;col<=row;col++) {
						{
							Point p1 = rowAndColumn2AWTCoord(new RowAndColumn(row,col));
							Point p2 = rowAndColumn2AWTCoord(new RowAndColumn(row+1,col));
							long slack = 0;
							try {
								slack = f.getSlack(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.DOWNRIGHT7));
							} catch (OutOfTriangleException e) {
								slack = 1;
							}
							if (slack!=0) g2.drawLine(p1.x, p1.y, p2.x, p2.y);
						}
						{
							Point p1 = rowAndColumn2AWTCoord(new RowAndColumn(row,col));
							Point p2 = rowAndColumn2AWTCoord(new RowAndColumn(row+1,col+1));
							long slack = 0;
							try {
								slack = f.getSlack(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.UPRIGHT5));
							} catch (OutOfTriangleException e) {
								slack = 1;
							}
							if (slack!=0) g2.drawLine(p1.x, p1.y, p2.x, p2.y);
						}
						{
							Point p1 = rowAndColumn2AWTCoord(new RowAndColumn(row+1,col));
							Point p2 = rowAndColumn2AWTCoord(new RowAndColumn(row+1,col+1));
							long slack = 0;
							try {
								slack = f.getSlack(new ThroughputPosition(new RowAndColumn(row+1,col),HexagonalDirection.UP3));
							} catch (OutOfTriangleException e) {
								slack = 1;
							}
							if (slack!=0) g2.drawLine(p1.x, p1.y, p2.x, p2.y);
						}
					}
				}
			}
			//</degeneracy graph>

			//<path>
			if (path!=null) {
				Stroke oldStroke = g2.getStroke();
				g2.setStroke(new BasicStroke(7));
				g.setColor(Color.RED);
				for (Turn t : path) {
					RowAndColumn rc1 = t.getStartPos().vertex;
					RowAndColumn rc2 = t.getStartPos().secondVertex();
					Point p1 = rowAndColumn2AWTCoord(rc1);
					Point p2 = rowAndColumn2AWTCoord(rc2);
					Point p = new Point((p1.x+p2.x)/2,(p1.y+p2.y)/2);
					rc1 = t.getEndPos().vertex;
					rc2 = t.getEndPos().secondVertex();
					p1 = rowAndColumn2AWTCoord(rc1);
					p2 = rowAndColumn2AWTCoord(rc2);
					Point q = new Point((p1.x+p2.x)/2,(p1.y+p2.y)/2);
					g.drawLine(p.x, p.y, q.x, q.y);
				}
				g2.setStroke(oldStroke);
			}
			//</path>
			
			//<arrows and flow values>
			{
				final double alpha = 0.35;
				final Color arrowColor = Color.getHSBColor(0.55f, 1.0f, 1.0f);//light blue
				for (int row=0;row<f.n;row++) {
					for (int col=0;col<=row;col++) {
						for (int dir=0;dir<3;dir++) {
							Point p1=null,p2=null,pA=null,pB=null;
							long throughput=0;
							switch(dir) {
							case 0:
								p1 = rowAndColumn2AWTCoord(new RowAndColumn(row,col));
								p2 = rowAndColumn2AWTCoord(new RowAndColumn(row+1,col));
								throughput = f.get(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.DOWNRIGHT7));
								pA = rowAndColumn2AWTCoord(new RowAndColumn(row,col-1));
								pB = rowAndColumn2AWTCoord(new RowAndColumn(row+1,col+1));
								break;
							case 1:
								p1 = rowAndColumn2AWTCoord(new RowAndColumn(row,col));
								p2 = rowAndColumn2AWTCoord(new RowAndColumn(row+1,col+1));
								throughput = f.get(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.UPRIGHT5));
								pA = rowAndColumn2AWTCoord(new RowAndColumn(row+1,col));
								pB = rowAndColumn2AWTCoord(new RowAndColumn(row,col+1));
								break;
							case 2:
								p1 = rowAndColumn2AWTCoord(new RowAndColumn(row+1,col));
								p2 = rowAndColumn2AWTCoord(new RowAndColumn(row+1,col+1));
								throughput = f.get(new ThroughputPosition(new RowAndColumn(row+1,col),HexagonalDirection.UP3));
								pA = rowAndColumn2AWTCoord(new RowAndColumn(row+2,col+1));
								pB = rowAndColumn2AWTCoord(new RowAndColumn(row,col));
								break;
							}
							Point pA2 = new Point((int)(pA.x*(1-alpha)+pB.x*alpha),(int)(pA.y*(1-alpha)+pB.y*alpha));
							Point pB2 = new Point((int)(pA.x*alpha+pB.x*(1-alpha)),(int)(pA.y*alpha+pB.y*(1-alpha)));
							g.setColor(arrowColor);
							if (throughput > 0) {
								g2.fill(createArrowShape(pA2, pB2));
							}
							if (throughput < 0) {
								g2.fill(createArrowShape(pB2, pA2));
							}
							if (throughput != 0) {
								if (throughput<0) throughput*=-1;
								Font oldFont = g.getFont();
								Font fo = new Font("Arial",Font.PLAIN, 18);
								g.setFont(fo);
								String s = ""+throughput;
								int width = g.getFontMetrics().stringWidth(s);
								int height = g.getFontMetrics().getHeight();
								g.setColor(Color.BLACK);
								g.drawString(s, (p1.x+p2.x)/2-width/2-1, (p1.y+p2.y)/2+height/3);
								g.drawString(s, (p1.x+p2.x)/2-width/2+1, (p1.y+p2.y)/2+height/3);
								g.drawString(s, (p1.x+p2.x)/2-width/2, (p1.y+p2.y)/2+height/3-1);
								g.drawString(s, (p1.x+p2.x)/2-width/2, (p1.y+p2.y)/2+height/3+1);
								g.setColor(Color.WHITE);
								g.drawString(s, (p1.x+p2.x)/2-width/2, (p1.y+p2.y)/2+height/3);
							    g.setFont(oldFont);
							}
						}
					}
				}
			}
			//</arrows and flow values>
			
			//<partitions at the border>
			{
				final double alpha = 0.8;
				g.setColor(Color.BLACK);
				for (int i=0;i<f.n;i++) {
					Point p1 = rowAndColumn2AWTCoord(new RowAndColumn(i,i+1));
					Point p2 = rowAndColumn2AWTCoord(new RowAndColumn(i+1,i));
					String s = ""+lambda.get(i);
					int width = g.getFontMetrics().stringWidth(s);
					int height = g.getFontMetrics().getHeight();
					g.drawString(s, (int)(p1.x*alpha+p2.x*(1-alpha))-width/2, (int)(p1.y*alpha+p2.y*(1-alpha))+height/3);
				}
				for (int i=0;i<f.n;i++) {
					Point p1 = rowAndColumn2AWTCoord(new RowAndColumn(f.n+1,i+1));
					Point p2 = rowAndColumn2AWTCoord(new RowAndColumn(f.n-1,i));
					String s = ""+mu.get(f.n-i-1);
					int width = g.getFontMetrics().stringWidth(s);
					int height = g.getFontMetrics().getHeight();
					g.drawString(s, (int)(p1.x*alpha+p2.x*(1-alpha))-width/2, (int)(p1.y*alpha+p2.y*(1-alpha))+height/3);
				}
				for (int i=0;i<f.n;i++) {
					Point p1 = rowAndColumn2AWTCoord(new RowAndColumn(i,-1));
					Point p2 = rowAndColumn2AWTCoord(new RowAndColumn(i+1,1));
					String s = ""+nu.get(i);
					int width = g.getFontMetrics().stringWidth(s);
					int height = g.getFontMetrics().getHeight();
					g.drawString(s, (int)(p1.x*alpha+p2.x*(1-alpha))-width/2, (int)(p1.y*alpha+p2.y*(1-alpha))+height/3);
				}
			}
			//</partitions at the border>
		}
	}
}
