package lrc;
/**
 * Produces TikZ code to visualize the flow.
 * For debug purposes.
 * @author ciken
 */

public final class FlowTikzVisualizer {
	private FlowTikzVisualizer() {};
	private static class Point {
		public double x,y;
		public Point(double x, double y) {
			this.x=x;this.y=y;
		}
		@Override
		public String toString() {
			String sx = ""+x;
			if (sx.length()>7) sx = sx.substring(0,7);
			String sy = ""+y;
			if (sy.length()>7) sy = sy.substring(0,7);
			return "("+ sx +"pt, " + sy  +"pt)";
		}
	}
	private static final double graphicsoffseti = 0;
	private static final double graphicsoffsetj = 0;
	private static final double graphicsscale = 40;
	//TikZ first coordinate: ---> left to right
	//TikZ second coordinate: ^ bottom to top
	private static Point rowAndColumn2tikzCoord(RowAndColumn rc) {
		double i=rc.col;
		double j=rc.row;
		i+=graphicsoffseti;
		j+=graphicsoffsetj;
		double I = graphicsscale*i;
		double J = graphicsscale*j;
		I = I-J*0.5;
		J = J *-0.866;
		return new Point(I,J);
	}

	final static boolean SLACK = false;
	/**
	 * Returns TikZ-code.
	 * Draws how many flow values enter an upright triangle.
	 * Lines are drawn through rhombi that are not flat.
	 */
	public static String flow2String(Flow f) {
		String ret = "\\begin{tikzpicture}";
		for (int row=0;row<f.n+1;row++) {
			for (int col=0;col<=row;col++) {
				Point p = rowAndColumn2tikzCoord(new RowAndColumn(row,col));
				ret+="\\fill "+p+" circle (1.8pt);";
			}
		}
		for (int row=0;row<f.n;row++) {
			for (int col=0;col<=row;col++) {
				Point p1 = rowAndColumn2tikzCoord(new RowAndColumn(row,col));
				Point p2 = rowAndColumn2tikzCoord(new RowAndColumn(row+1,col));
				long slack = 0;
				try {
					slack = f.getSlack(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.DOWNRIGHT7));
				} catch (OutOfTriangleException e) {
					slack = Long.MAX_VALUE;
				}
				if (slack>0) {
					if (slack==1) ret+="\\draw[color=blue] "+p1+" -- "+p2+";";
					else ret+="\\draw "+p1+" -- "+p2+";";
				}
				if (slack<0) {
					ret+="\\draw[color=red] "+p1+" -- "+p2+";";
				}
				Point p = new Point(0.5*(p1.x+p2.x),0.5*(p1.y+p2.y));
				if (!SLACK) ret+="\\node at "+p+" {"+f.get(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.DOWNRIGHT7))+"};";
				if (SLACK) try{ret+="\\node at "+p+" {"+f.getSlack(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.DOWNRIGHT7))+"};";}catch(OutOfTriangleException e) {}
			}
		}
		for (int row=0;row<f.n;row++) {
			for (int col=0;col<=row;col++) {
				Point p1 = rowAndColumn2tikzCoord(new RowAndColumn(row,col));
				Point p2 = rowAndColumn2tikzCoord(new RowAndColumn(row+1,col+1));
				long slack = 0;
				try {
					slack = f.getSlack(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.UPRIGHT5));
				} catch (OutOfTriangleException e) {
					slack = Long.MAX_VALUE;
				}
				if (slack>0) {
					if (slack==1) ret+="\\draw[color=blue] "+p1+" -- "+p2+";";
					else ret+="\\draw "+p1+" -- "+p2+";";
				}
				if (slack<0) {
					ret+="\\draw[color=red] "+p1+" -- "+p2+";";
				}
				Point p = new Point(0.5*(p1.x+p2.x),0.5*(p1.y+p2.y));
				if (!SLACK) ret+="\\node at "+p+" {"+-f.get(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.UPRIGHT5))+"};";
				if (SLACK) try{ret+="\\node at "+p+" {"+f.getSlack(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.UPRIGHT5))+"};";}catch(OutOfTriangleException e) {}
			}
		}
		for (int row=1;row<f.n+1;row++) {
			for (int col=0;col<=row-1;col++) {
				Point p1 = rowAndColumn2tikzCoord(new RowAndColumn(row,col));
				Point p2 = rowAndColumn2tikzCoord(new RowAndColumn(row,col+1));
				long slack = 0;
				try {
					slack = f.getSlack(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.UP3));
				} catch (OutOfTriangleException e) {
					slack = Long.MAX_VALUE;
				}
				if (slack>0) {
					if (slack==1) ret+="\\draw[color=blue] "+p1+" -- "+p2+";";
					else ret+="\\draw "+p1+" -- "+p2+";";
				}
				if (slack<0) {
					ret+="\\draw[color=red] "+p1+" -- "+p2+";";
				}
				Point p = new Point(0.5*(p1.x+p2.x),0.5*(p1.y+p2.y));
				if (!SLACK) ret+="\\node at "+p+" {"+f.get(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.UP3))+"};";
				if (SLACK) try{ret+="\\node at "+p+" {"+f.getSlack(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.UP3))+"};";}catch(OutOfTriangleException e){}
			}
		}
		ret+="\\end{tikzpicture}";
		return ret;
	}





	/**
	 * Returns TikZ-code.
	 * Can be used to visualize when LRC=2
	 */
	public static String flowPair2String(Flow f, Flow g) {
		String ret = "\\begin{tikzpicture}";
		for (int row=0;row<f.n+1;row++) {
			for (int col=0;col<=row;col++) {
				Point p = rowAndColumn2tikzCoord(new RowAndColumn(row,col));
				ret+="\\fill "+p+" circle (1.8pt);";
			}
		}
		for (int row=0;row<f.n;row++) {
			for (int col=0;col<=row;col++) {
				Point p1 = rowAndColumn2tikzCoord(new RowAndColumn(row,col));
				Point p2 = rowAndColumn2tikzCoord(new RowAndColumn(row+1,col));
				long fslack = 0;
				long gslack = 0;
				try {
					fslack = f.getSlack(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.DOWNRIGHT7));
					gslack = g.getSlack(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.DOWNRIGHT7));
				} catch (OutOfTriangleException e) {
					fslack = Long.MAX_VALUE;
					gslack = Long.MAX_VALUE;
				}
				if (fslack>0 && gslack>0) {
					ret+="\\draw "+p1+" -- "+p2+";";
				}
				if (fslack>0 && gslack==0) {
					ret+="\\draw[blue, thick] "+p1+" -- "+p2+";";
				}
				if (fslack==0 && gslack>0) {
					ret+="\\draw[green, thick] "+p1+" -- "+p2+";";
				}
				if (fslack<0 || gslack<0) {
					ret+="\\draw[color=red, thick] "+p1+" -- "+p2+";";
				}
			}
		}
		for (int row=0;row<f.n;row++) {
			for (int col=0;col<=row;col++) {
				Point p1 = rowAndColumn2tikzCoord(new RowAndColumn(row,col));
				Point p2 = rowAndColumn2tikzCoord(new RowAndColumn(row+1,col+1));
				long fslack = 0;
				long gslack = 0;
				try {
					fslack = f.getSlack(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.UPRIGHT5));
					gslack = g.getSlack(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.UPRIGHT5));
				} catch (OutOfTriangleException e) {
					fslack = Long.MAX_VALUE;
					gslack = Long.MAX_VALUE;
				}
				if (fslack>0 && gslack>0) {
					ret+="\\draw "+p1+" -- "+p2+";";
				}
				if (fslack>0 && gslack==0) {
					ret+="\\draw[blue, thick] "+p1+" -- "+p2+";";
				}
				if (fslack==0 && gslack>0) {
					ret+="\\draw[green, thick] "+p1+" -- "+p2+";";
				}
				if (fslack<0 || gslack<0) {
					ret+="\\draw[color=red, thick] "+p1+" -- "+p2+";";
				}
//				Point p = new Point(0.5*(p1.x+p2.x),0.5*(p1.y+p2.y));
//				if (!SLACK) ret+="\\node at "+p+" {"+-f.get(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.UPRIGHT5))+"};";
//				if (SLACK) try{ret+="\\node at "+p+" {"+f.getSlack(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.UPRIGHT5))+"};";}catch(OutOfTriangleException e) {}
			}
		}
		for (int row=1;row<f.n+1;row++) {
			for (int col=0;col<=row-1;col++) {
				Point p1 = rowAndColumn2tikzCoord(new RowAndColumn(row,col));
				Point p2 = rowAndColumn2tikzCoord(new RowAndColumn(row,col+1));
				long fslack = 0;
				long gslack = 0;
				try {
					fslack = f.getSlack(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.UP3));
					gslack = g.getSlack(new ThroughputPosition(new RowAndColumn(row,col),HexagonalDirection.UP3));
				} catch (OutOfTriangleException e) {
					fslack = Long.MAX_VALUE;
					gslack = Long.MAX_VALUE;
				}
				if (fslack>0 && gslack>0) {
					ret+="\\draw "+p1+" -- "+p2+";";
				}
				if (fslack>0 && gslack==0) {
					ret+="\\draw[blue, thick] "+p1+" -- "+p2+";";
				}
				if (fslack==0 && gslack>0) {
					ret+="\\draw[green, thick] "+p1+" -- "+p2+";";
				}
				if (fslack<0 || gslack<0) {
					ret+="\\draw[color=red, thick] "+p1+" -- "+p2+";";
				}
			}
		}
		ret+="\\end{tikzpicture}";
		return ret;
	}




}
