package lrc;
/**
 * immutable class.
 * Consists of a ThroughputPosition and a turn direction "LEFT" (counterclockwise) or "RIGHT" (clockwise).
 * @author ciken
 */
public final class Turn {
	public enum LeftRight {
		LEFT {public LeftRight swap() {return RIGHT;}},
		RIGHT {public LeftRight swap() {return LEFT;}};
		public abstract LeftRight swap();
	}
	private final ThroughputPosition startPos;
	public final LeftRight course;
	/**
	 * Construct a turn starting at startPos.
	 */
	public Turn(ThroughputPosition startPos,LeftRight course) {
		this.startPos=startPos;
		this.course=course;
	}
	/**
	 * Construct a turn ending at endPos.
	 */
	public Turn(LeftRight course, ThroughputPosition endPos) {
		this.course=course;
		if (course==LeftRight.LEFT) {
			this.startPos=endPos.goccw().goccw().goccw().goccw().goccw();
		} else {
			this.startPos=endPos.gocw().gocw().gocw().gocw().gocw();
		}
	}
	/**
	 * Get the turns starting position.
	 */
	public ThroughputPosition getStartPos() {
		return startPos;
	}
	/**
	 * Get the turns ending position.
	 */
	public ThroughputPosition getEndPos() {
		if (course==LeftRight.LEFT) return startPos.goccw(); else return startPos.gocw();
	}
	/**
	 * Constructs a turn which can be appended to this turn.
	 * @param course Determines whether the returned turn will be clockwise or counterclockwise. 
	 */
	public Turn nextTurn(LeftRight course) {
		if (course==LeftRight.LEFT) return new Turn(getEndPos(),course); else return new Turn(getEndPos(),course);
	}
	/**
	 * Checks whether this turn lies completely in the area of the triangular graph.
	 */
	public boolean liesInBigTriangle(int n) {
		return getStartPos().liesInBigTriangle(n) && getEndPos().liesInBigTriangle(n);
	}
	@Override
	public int hashCode() {
		return startPos.hashCode()+31*course.hashCode();
	}
	@Override
	public boolean equals(Object o) {
		if (o instanceof Turn) {
			Turn t = (Turn)o;
			return t.course==course && t.startPos.equals(startPos);
		}
		return false;
	}
	@Override
	public String toString() {
		return getStartPos()+" >-"+course+"-> "+getEndPos();
	}
}
