package lrc;
/**
 * immutable class.
 * coordinate system (row,col) is as follows:
 * 
 *                 (0,0)
 * 
 *             (1,0)   (1,1)
 * 
 *         (2,0)   (2,1)    (2,2)
 * 
 *      etc.
 * 
 * @author ciken
 */
public final class RowAndColumn {
	public final int row;
 	public final int col;
 	public RowAndColumn(int row, int col) {
 		this.row=row;this.col=col;
	}
	public static RowAndColumn sum(RowAndColumn rac0, RowAndColumn rac1) {
		return new RowAndColumn(rac0.row+rac1.row,rac0.col+rac1.col);
	}
	public boolean isVertexOfBigTriangle(int n) {
		return 0 <= col && col <= row && row <= n;
	}
	@Override
	public int hashCode() {
		return new Integer(row).hashCode()+31*new Integer(col).hashCode();
	}
	@Override
	public boolean equals(Object o) {
		if (o instanceof RowAndColumn) {
			RowAndColumn rc = (RowAndColumn)o;
			return rc.row==row && rc.col==col;
		}
		return false;
	}
	@Override
	public String toString() {
		return "row="+row+" col="+col;
	}
}
