#Creates the .hwv files for a whole directory.

#example usage:
#python3 tableau2polynomial_directory.py "\"../db/PlethysmDB4/Inner3/"\" 4 3 4

#parameters:
#(1) The directory in the database where the tableau files are stored
#(2) The outer plethysm parameter
#(3) The inner plethysm parameter
#(4) The maximum number of rows

import sys
import os

if sys.version_info.major <= 2:
  print("Python must be at least version 3.")
  exit()

directory = eval(sys.argv[1])
OUTERDEGREE = eval(sys.argv[2])
INNERDEGREE = eval(sys.argv[3])
maxrows = eval(sys.argv[4])

def main():
  for dirpath,_,filenames in os.walk(directory):
    for filename in filenames:
      absolutefilename = os.path.abspath(os.path.join(dirpath, filename))
      if absolutefilename.endswith(".txt"):
        f = open(absolutefilename)
        triple = eval(f.readline())
        f.close()
        partition = triple[0]
        if len(partition)>maxrows:
          continue
        plethysmcoefficient = triple[1]
        tableaux = triple[2]
        for i in range(plethysmcoefficient):
          hwvfilename = str(partition).replace(" ","")
          hwvfilename = hwvfilename + str(tableaux[i]).replace(" ","")
          hwvfilename = hwvfilename + ".hwv"
          hwvfilename = absolutefilename[:absolutefilename.rindex("/")] + "/" + hwvfilename
          if not os.path.exists(hwvfilename):
            print("Computing new database entry: "+hwvfilename, flush=True)
            os.system("python3 tableau2polynomial.py \"\\\""+str(tuple(partition))+"\"\\\" "+str(OUTERDEGREE)+" "+str(INNERDEGREE)+" \"\\\""+str(tuple(tableaux[i]))+"\"\\\"")
            if os.path.exists("hwv.hwv"):
              os.rename("hwv.hwv",hwvfilename)
              print("New database entry created!", flush=True)
            else:
              print("ERROR (probably out of memory)! Could not create new database entry: "+hwvfilename, flush=True)

main()

