import Pkg;
deps = Pkg.dependencies()
installs = Vector{String}()
for (uuid, dep) in deps
  dep.is_direct_dep || continue
  push!(installs,dep.name)
end

if !in("DynamicPolynomials",installs) Pkg.add("DynamicPolynomials")end



print("loading highest weight polynomial code ...")

include("hwvs.jl")

print("done loading highest weight polynomial code.\n")

print("setting up the parametrized polynomial ...")

#To compute equations, the variables of the parametrized polynomial must be called "x" and "y", where y are the variables used for sampling, i.e., the y[i] will be replaced with a random number to obtain a random point in the variety of polynomials that are defined in x-variables.


@polyvar x[1:4]
@polyvar y[1:40]
M = [
y[1]*x[1]+y[2]*x[2]+y[3]*x[3]+y[4]*x[4]  y[5]*x[1]+y[6]*x[2]+y[7]*x[3]+y[8]*x[4]  y[9]*x[1]+y[10]*x[2]+y[11]*x[3]+y[12]*x[4]  y[13]*x[1]+y[14]*x[2]+y[15]*x[3]+y[16]*x[4]  ; 
y[5]*x[1]+y[6]*x[2]+y[7]*x[3]+y[8]*x[4]  y[17]*x[1]+y[18]*x[2]+y[19]*x[3]+y[20]*x[4]  y[21]*x[1]+y[22]*x[2]+y[23]*x[3]+y[24]*x[4]  y[25]*x[1]+y[26]*x[2]+y[27]*x[3]+y[28]*x[4]  ;  
y[9]*x[1]+y[10]*x[2]+y[11]*x[3]+y[12]*x[4]  y[21]*x[1]+y[22]*x[2]+y[23]*x[3]+y[24]*x[4]  y[29]*x[1]+y[30]*x[2]+y[31]*x[3]+y[32]*x[4]  y[33]*x[1]+y[34]*x[2]+y[35]*x[3]+y[36]*x[4]  ;  
y[13]*x[1]+y[14]*x[2]+y[15]*x[3]+y[16]*x[4]  y[25]*x[1]+y[26]*x[2]+y[27]*x[3]+y[28]*x[4]  y[33]*x[1]+y[34]*x[2]+y[35]*x[3]+y[36]*x[4]  y[37]*x[1]+y[38]*x[2]+y[39]*x[3]+y[40]*x[4]
]
p = det(M)



print("done setting up the parametrized polynomial.\n")



#There are three ways to compute equations and all of them append the equations into a file instead of returning them.

#(1)
#computeequations_partition(partition,parametrized_polynomial,directory_of_database,file_in_which_the_equations_are_written)
#
#This checks for a specific weight if there are equations of that one weight

#(2)
#computeequations_degree(degree,maxrows,parametrized_polynomial,directory_of_database,file_in_which_the_equations_are_written)
#
#This checks for a specific degree if there are equations of exactly that degree.
#maxrows specifies the maximum number of rows in a Young diagram that is checked. If in doubt, maxrows should be set to length(x).

#(3)
#computeequations_degrees(degree_start,degree_end,maxrows,parametrized_polynomial,directory_of_database,file_in_which_the_equations_are_written)
#
#This checks for a specific range of degrees if there are equations of exactly that degree.
#maxrows specifies the maximum number of rows in a Young diagram that is checked. If in doubt, maxrows should be set to length(x).


eqnfile = "eqnfile.txt"
io = open(eqnfile, "w") #clears the equation file
close(io)


print("computing equations ... \n")

computeequations_degrees(1,6,4,p,"../db",eqnfile)

print("done computing equations.\n")
