package lrc;
/**
 * This enumaration holds the 6 direcitons emanating from a vertex on the triangular graph:
 * <pre>
 *                                                                            
 *                 DOWNLEFT11           UPLEFT1                               
 *                        \               /                                   
 *                         \             /                                    
 *                          \           /                                     
 *                           \         /                                      
 *                            \       /                                       
 *                             \     /                                        
 *          DOWN9 --------------- O --------------- UP3                       
 *                             /     \                                        
 *                            /       \                                       
 *                           /         \                                      
 *                          /           \                                     
 *                         /             \                                    
 *                        /               \                                   
 *                 DOWNRIGHT7          UPRIGHT5                               
 *                                                                            
 *                                                                            
 * </pre>
 * The numbers represent the position on the clock.
 * The direction indicates in which direction the normal vector of this direction is poiting.
 * 
 * @author ciken
 *
 */
public enum HexagonalDirection {
	UP3
	{
		public RowAndColumn getRowAndColumn() {return new RowAndColumn(0,1);}
		public HexagonalDirection cw() {return UPRIGHT5;}
		public HexagonalDirection ccw() {return UPLEFT1;}
	},
	UPLEFT1
	{
		public RowAndColumn getRowAndColumn() {return new RowAndColumn(-1,0);}
		public HexagonalDirection cw() {return UP3;}
		public HexagonalDirection ccw() {return DOWNLEFT11;}
	},
	DOWNLEFT11
	{
		public RowAndColumn getRowAndColumn() {return new RowAndColumn(-1,-1);}
		public HexagonalDirection cw() {return UPLEFT1;}
		public HexagonalDirection ccw() {return DOWN9;}
	},
	DOWN9
	{
		public RowAndColumn getRowAndColumn() {return new RowAndColumn(0,-1);}
		public HexagonalDirection cw() {return DOWNLEFT11;}
		public HexagonalDirection ccw() {return DOWNRIGHT7;}
	},
	DOWNRIGHT7
	{
		public RowAndColumn getRowAndColumn() {return new RowAndColumn(1,0);}
		public HexagonalDirection cw() {return DOWN9;}
		public HexagonalDirection ccw() {return UPRIGHT5;}
	},
	UPRIGHT5
	{
		public RowAndColumn getRowAndColumn() {return new RowAndColumn(1,1);}
		public HexagonalDirection cw() {return DOWNRIGHT7;}
		public HexagonalDirection ccw() {return UP3;}
	};

	/**
	 * converts this hexagonal direction into a directional vector
	 */
	public abstract RowAndColumn getRowAndColumn();
	/**
	 * clockwise
	 */
	public abstract HexagonalDirection cw();
	/**
	 * counterclockwise
	 */
	public abstract HexagonalDirection ccw();
}
